Ext.define('Academia.view.personinfo.common.documents.DocumentGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.documentgrid',
	title: getPersonModuleTranslation('LIST_OF_DOCUMENTS'),
	border : true,
	enableColumnHide : false,
	isGridConfigurable: true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    },{
    	xtype: 'button',
    	itemId: 'uploadDocumentBtn',
    	tooltip: getCommonTranslation('UPLOAD'),
    	text: getCommonTranslation('UPLOAD'),
    	hasDisableForProfileViewMode:true
    },{
    	xtype: 'button',
    	itemId: 'updateBulkDocumentBtn',
    	tooltip: getCommonTranslation('BULK_DOCUMENT_STATUS_UPDATE'),
    	text: getCommonTranslation('BULK_DOCUMENT_STATUS_UPDATE'),
    	hasDisableForProfileViewMode:true,
    	hidden:true
    }
    /*{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon',
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }*/],
    columns : [{
    	header : getCommonTranslation('DOCUMENTS_NAME'),
    	dataIndex : 'documentType',
    	itemId:'documentTypeItem',
    	sortable : true,
    	flex : .2,
    	renderer : function(value, metadata, record){
    		var msg = "";
    		if(!isEmpty(value) && record.get('isElectronic')==true){
    			msg = '<a href="#">'+columnObjRender(value,"value")+'</a>';
    		}else{
    			msg = columnObjRender(value,"value");
    		}
    		return msg;
    	}
    },{
    	header : getCommonTranslation('DOCUMENTS_TYPE'),
    	dataIndex : 'documentApplicability',
    	itemId:'documentApplicabilityItem',
    	sortable : true,
    	flex : .2,
    	hidden:true,
    	renderer: function(obj) {
    		return getAdmissionTranslation(obj);
    	}
    }, {
    	header : getCommonTranslation('DATE_SUBMISSION'),
    	dataIndex : 'submissionDate',
    	sortable : true,
    	flex : .2,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header : getCommonTranslation('RETURNED_DATE'),
    	dataIndex : 'returnedDate',
    	itemId:'returnedDateItem',
    	sortable : true,
    	flex : .2,
    	hidden:true,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header : getCommonTranslation('MODE_SUBMISSION'),
    	dataIndex : 'modeOfSubmission',
    	sortable : true,
    	flex : .2,
    	renderer:function(value){
    		if(!isNullOrEmpty(value)){
    			value=getPersonModuleTranslation(value);
    		}else{
    			value='';
    		}
    		return value;
    	}
    }, {
    	header : getCommonTranslation('INSPECTION_DATE'),
    	dataIndex : 'inspectionDate',
    	itemId:'inspectionDateItem',
    	sortable : true,
    	flex : .2,
    	hidden:true,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header : getCommonTranslation('STATUS'),
    	dataIndex : 'documentStatusCSM',
    	sortable : true,
    	flex : .2,
    	renderer : function(value, metadata, record){
    		if(!isNullOrEmpty(value)){
    			if(value.code == 'PENDING' || value.code == 'PENDING_OPTIONAL'){
    				return '<span style="color:red;">' + "Pending" + '</span>';
    			}else{
    				return value.value;
    			}

    		}
    	}

    },{
    	header : getCommonTranslation('PROGRAM_BATCH_SEAT_ASSOCIATED'),
    	dataIndex : 'programBatchSeatTypeAssociated',
    	sortable : true,
    	flex : .2,
    	renderer:function(value,meta,record){
    		if(!isNullOrEmpty(value)) {
    			if(value>0){
    				return '<a href=#>'+value+'</a>';
    			}else
    			{
    				return '';
    			}	
    			
    		}                        
    	}
    } ,
     {
        header: getCommonTranslation('NOTE'),
        dataIndex: 'documentNote',
        flex: .2,
        sortable: true,
        renderer : function(value,meta,record){
        	if( portalId == 6 ){
        	if(!(isNullOrEmpty(value)) && record.data.visibleNoteOnPortal == true ){
        		return  '<a href="#">'+"View"+'</a>';
        	}else{
        		return  '';
        	}
        	}else{
        		if(!isNullOrEmpty(value)){
            		return  '<a href="#">'+"View"+'</a>';
            	}else{
            		return '';
            	}
        	}
        }
    },{
    	header: getCommonTranslation('PREVIEW'),
    	dataIndex: 'previewDoc',
    	itemId: 'onlineDocGridPreviewBtn',
    	flex : .2,
    	renderer: function(value, meta, record) {
        	if(!isNullOrEmpty(record.data.path) && isImageOrPDFDocument(record.data.path)){
           return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;" >'+getCommonTranslation('PREVIEW')+'</a>';
        	}
        	else{
        		return "-";
        	}
    	}
    }/*,{
    	header : getAdmissionTranslation('PROGRAM'),
    	dataIndex : 'programName',
    	sortable : true,
    	flex : .2,
    },{
    	header : getAdmissionTranslation('BATCH'),
    	dataIndex : 'batchName',
    	sortable : true,
    	flex : .2,
    },{
    	header : getAdmissionTranslation('SEAT_TYPE'),
    	dataIndex : 'seatType',
    	sortable : true,
    	flex : .2,
    }*/],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore(this$.personType);
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function(personType) {
    	if(personType === 'APPLICANT' || this.itemId == "applicantDocumentGrid"){
    		return Ext.create('Academia.store.admission.applications.applicantdocuments.ApplicantDocumentStore');
    	}else{ //Here to put case for STUDENT Or FACULTY   
    		return Ext.create('Academia.store.personinfo.common.documents.DocumentStore');
    	}    	        
    }

});