/**
 * 
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.personinfo.common.documents.PhysicalDocumentFormWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.physicaldocumentformwin',
    title: getPersonModuleTranslation('DOCUMENTS_DETAILS'),
    autoScroll: true,
    modal: true,
    height: '75%',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'physicalDocumentFormItemId',
        items: [{
            xtype: 'hidden',
            itemId: 'document_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'module'
        }, {
            xtype: 'hidden',
            name: 'entityId'
        }, {
            xtype: 'hidden',
            name: 'entityType'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            width: 400,
            items: [{
                xtype: 'radiogroup',
                itemId: 'documentType',
                style: {
                    marginLeft: '8px'
                },
                defaults: {
                    flex: .1
                },
                items: [{
                    boxLabel: getPersonModuleTranslation('DOC_PREDFINED_DOCUMENTS'),
                    name: 'isPreDefined',
                    itemId: 'preDefined',
                    inputValue: true,
                    checked: true

                }, {
                    boxLabel: getPersonModuleTranslation('OTHERS'),
                    name: 'isPreDefined',
                    itemId: 'otherItemId',
                    inputValue: false,
                }]
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
            	xtype: 'nestedJsonCombo',
            	fieldLabel: getPersonModuleTranslation('DOCUMENTS_TYPE'),
            	//store: 'common.DocumentTypeStore',
            	store: Ext.create('Academia.store.common.DocumentTypeStore'),
            	name: 'documentType',
            	displayField: 'value',
            	valueField: 'id',
            	forceSelection: true,
            	editable: false,
            	allowBlank: false,
            	itemId: 'documentTypeCombo'
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('DOCUMENTS_NAME'),
                name: 'documentName',
                itemId: 'documentNameItemId',
                readOnly: false,
                allowBlank: false,
                hidden: true,
            }, {
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_SUBMISSION'),
                name: 'submissionDate',
                itemId: 'submissionDate',
                //			  		value: new Date(),
                readOnly: true,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                allowBlank: false,
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                        obj.setValue(new Date());
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileFieldContainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'livesearchcombo',
                itemId: 'responsibleUserField',
                fieldLabel: getPersonModuleTranslation('PHYSICAL_DOCUMENTS'),
                name: 'responsibleUser',
                minChars: 3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                allowBlank: false
            }, {
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('MODE_SUBMISSION'),
                store: 'document.DocumentModeSubmissionStore',
                name: 'modeOfSubmission',
                valueField: 'name',
                displayField: 'value',
                itemId: 'modeOfSubmission',
                editable: false,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileInfoContainer',
            hidden: true,
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'displayfield',
                itemId: 'docDetails'
            }]
        }, {

            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileRemarkContainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'textfield',
                itemId: 'remarkItemId',
                fieldLabel: getPersonModuleTranslation('REMARK'),
                name: 'remark',
                maxLength: 255,
                readOnly: false,
                allowBlank: true
            }]

        }, {
            xtype: 'radiogroup',
            itemId: 'inspectionDoneRadioGroupField',
            fieldLabel: getPersonModuleTranslation('INSPECTION_DONE'),
            columns: 2,
            vertical: true,
            hidden: true,
            labelWidth : 105,
            name: 'isInspectionDone',
            items: [{
                itemId: 'isInspectionDoneYesField',
                boxLabel: getPersonModuleTranslation('YES'),
                name: 'isInspectionDone',
                inputValue: true
            }, {
                itemId: 'isInspectionDoneNoField',
                boxLabel: getPersonModuleTranslation('NO'),
                name: 'isInspectionDone',
                inputValue: false,
                checked: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'inspectionDateContainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'datefield',
                itemId: 'inspectionDateField',
                fieldLabel: getPersonModuleTranslation('INSPECTED_DATE'),
                name: 'inspectionDate',
                allowBlank: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                hidden: true,
                disabled: true,
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            }, {
                xtype: 'livesearchcombo',
                itemId: 'inspectionDoneByField',
                fieldLabel: getPersonModuleTranslation('INSPECTED_BY'),
                minChars: 3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                name: 'inspectionDoneBy',
                allowBlank: false,
                hidden: true,
                disabled: true
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'returnableContainer',
            layout: 'fit',
            items: [{
                xtype: 'radiogroup',
                fieldLabel: getPersonModuleTranslation('RETURNABLE'),
                columns: 2,
                vertical: true,
                labelWidth : 75,
                hidden: true,
                itemId: 'returnableRadioGroup',
                name: 'isReturnable',
                items: [{
                    itemId: 'isReturnableYesField',
                    boxLabel: getPersonModuleTranslation('YES'),
                    name: 'isReturnable',
                    inputValue: true
                }, {
                    itemId: 'isReturnableNoField',
                    boxLabel: getPersonModuleTranslation('NO'),
                    name: 'isReturnable',
                    inputValue: false,
                    checked: true
                }]
            }]

        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'returnDateContainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'datefield',
                itemId: 'returnDateField',
                fieldLabel: getPersonModuleTranslation('RETURENED_DATE'),
                name: 'returnedDate',
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                allowBlank: false,
                hidden: true,
                disabled: true,
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            }, {
                xtype: 'livesearchcombo',
                itemId: 'returnByField',
                fieldLabel: getPersonModuleTranslation('RETURENED_BY'),
                name: 'returnedBy',
                minChars: 3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                allowBlank: false,
                disabled: true,
                hidden: true,
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileStatusContainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'nestedJsonCombo',
                itemId: 'documentStatus',
                fieldLabel: getPersonModuleTranslation('STATUS'),
              //  store: 'document.DocumentStatusStore',
                 store: 'common.DocumentStatusCSMStore',
                name: 'documentStatusCSM',
                valueField: 'id',
                displayField: 'value',
                readOnly: true,
                editable: false,
               // value: 'SUBMITTED',
                allowBlank: false
            }]


        },{
	       xtype: 'textareafield',
	       name: 'documentNote',
	       itemId : 'documentNoteId',
	       fieldLabel: getCommonTranslation('NOTE'),
	       labelAlign: 'top',
	       width: 475,
	       height: 100,
	       maxLength: 500
	  }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'documentFormSubmitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'documentCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});