/**
 * This grid is used for student and faculty feedback given
 * @author Sachin.Bangar 
 */

Ext.define('Academia.view.personinfo.common.feedback.FeedbackGivenGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feedbackgivengrid',
	title : getPersonModuleTranslation('FEEDBACK_GIVEN_DETAILS'),
	border : true,
	autoScroll : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : [ {
		xtype : 'button',
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls : 'view-icon'
	} ],
	columns : [ {
		header : getPersonModuleTranslation('QUESTIONNAIRE_NUMBER'),
		dataIndex : 'questionnaireNumber',
		sortable : true,
		flex : .2
	}, {
		header : getPersonModuleTranslation('FEEDBACK_GIVEN_TO'),
		dataIndex : 'feedbackGivenTo',
		sortable : true,
		flex : .2
	}, {
		header : getPersonModuleTranslation('SUBMITTED_DATE'),
		dataIndex : 'submittedDate',
		sortable : true,
		flex : .2,
		renderer:function(date) {
			return dateRender(date);
		}
	} ],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.feedback.FeedbackGivenStore');
    }

});