Ext.define('Academia.view.personinfo.common.pasthistory.CompetitiveExamGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.competitiveexamgrid',
    title: getPersonModuleTranslation('COMPETITIVE_EXAM_DETAILS'),
    border: true,
    viewConfig: {
		stripeRows : CONSTANTS.STRIPEROWS
		},
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getPersonModuleTranslation('NAME_OF_EXAM'), 
        dataIndex: 'examinationName',
        sortable:true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, "value");
        }
    }, {
        header: getPersonModuleTranslation('REGISTRATION_ENROLMENT_NO'), 
        dataIndex: 'enrollmentNumber',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('YEAR_OF_EXAM'), 
        dataIndex: 'yearOfExamination',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('SCORE'), 
        dataIndex: 'score',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('PERCENTILE'),
        dataIndex: 'percentile',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('RANK_1'), 
        dataIndex: 'rankOne',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('RANK_2'), 
        dataIndex: 'rankTwo',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('SUBJECT_SPECIALIZATION'),
        dataIndex: 'specialization',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('DOCUMENT'),
        dataIndex: 'filePath',
        sortable:true,
        flex: .2,
        renderer:function(value){
			if (!isNullOrEmpty(value) && value) {
				return  '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
			}else{
				return  '-';
			}
		}
    }],
    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.pasthistory.CompetitiveExamGridStr');
    }
});