/**
 * @Author Amit G
 */
Ext.define('Academia.view.personinfo.common.pasthistory.HealthInformationDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.healthinformationdetailgrid',
	title: getCommonTranslation('HEALTH_INFORMATION'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	autoScroll: false,
	/*defaults:{
        width:'100%'
    },
    layout:'vbox',*/
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],

	columns: [ {
		header: getCommonTranslation('MEDICAL_CONDITIONS'), 
		dataIndex: 'MedicalConditionsNameVal',
		sortable: true,
		flex: .2
	}, {
		header: getCommonTranslation('MEDICAL_CONDITIONS_NAME'), 
		dataIndex: 'medicalConditionOther',
		sortable:true,
		flex: .2,
		hidden:true,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
	}, {
		header: getCommonTranslation('MEDICATION'), 
		dataIndex: 'medicationNameVal',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('MEDICATION_NAME'), 
		dataIndex: 'medicationOther',
		sortable:true,
		flex: .2,
		hidden:true,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}

	}, {
		header: getCommonTranslation('ALLERGIES'), 
		dataIndex: 'allergiesNameVal',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('ALLERGIES_NAME'), 
		dataIndex: 'allergiesOther',
		sortable:true,
		flex: .2,
		hidden:true,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
	},{
		header: getCommonTranslation('LEARNING_DIFFICULTIES'), 
		dataIndex: 'learningDifficultiesNameVal',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('LEARNING_DIFFICULTIES_NAME'), 
		dataIndex: 'learningDifficultiesOther',
		sortable:true,
		flex: .2,
		hidden:true,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
	}, {
		header: getCommonTranslation('UPLOAD_DOCUMENT'), 
		dataIndex: 'healthUploadDocument',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.studentHealthDocument.length)) {
				if(record.data.studentHealthDocument.length>1) {					
					return '<a href=#>'+record.data.studentHealthDocument.length+'<a>';
				} else if(record.data.studentHealthDocument.length==1) {
					var pathSplit=record.data.studentHealthDocument[0].path.split('/');
		            var newPath=pathSplit[2];
					var newName=record.data.studentHealthDocument[0].name;
					var newValue=newName!=null?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                        
		}
	}, {
		header: getCommonTranslation('UPLOAD_URL'),
		dataIndex: 'healthUploadUrl',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.studentHealthDocumentUrl.length)) {
				if(record.data.studentHealthDocumentUrl.length>1) {					
					return '<a href=#>'+record.data.studentHealthDocumentUrl.length+'<a>';
				} else if(record.data.studentHealthDocumentUrl.length==1) {
					var newPath=record.data.studentHealthDocumentUrl[0].path;
					var newName=record.data.studentHealthDocumentUrl[0].name;
					var newValue=newName!=""?newName:newPath;
					var prefix = 'https://';
					if (newPath.substr(0, prefix.length) !== prefix){
//					    s = prefix + s;
						return "<a href="+prefix+newPath+" target='_blank'>"+newValue;
				    }else {
				    	return "<a href="+newPath+" target='_blank'>"+newValue;
				    }
				} 
			}                        
		} 
	  }],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.HealthInformationDetailStore');
    }
});