/**
 *  @Dharmendra.Prajapati
 *  Hostel Details Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.HostelPersonDetailsGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.hostelpersondetailsgrid',
	title: getHostelTranslation('HOSTEL_DETAILS'),
	border: true,
	border: true,
	viewConfig: {
		stripeRows: true
	},
	/*tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],*/
	columns: [/*{
        header: getHostelTranslation('STUDENT_ID'),
        dataIndex: 'studentId',
        sortable: true,
        flex: .2
    },*/ {
    	header : getHostelTranslation('HOSTEL_CODE_NAME'),
    	dataIndex : 'hostelCodeName',
    	flex:.2,
    	renderer:function(value,record){
    		var hostelCodeName='';
    		if(!isNullOrEmpty(record.record.get("hostelCode") )){
    			var hostelCode = record.record.get("hostelCode");
    			var hostelName = record.record.get("hostelName");
    			hostelCodeName = hostelCode+ '/' +hostelName;
    		}
    		return  hostelCodeName;			 
    	}
    },{
    	header : getHostelTranslation('BUILDING_CODE_NAME'),
    	dataIndex : 'buildingCode',
    	flex:.2,
    	renderer:function(value,record){
    		var buildingCodeName='';
    		if(!isNullOrEmpty(record.record.get("buildingCode") )){
    			var buildingCode = record.record.get("buildingCode");
    			var buildingName = record.record.get("buildingName");
    			buildingCodeName = buildingCode+ '/' +buildingName;
    		}
    		return  buildingCodeName;			 
    	}
    },{
    	header: getHostelTranslation('FLOOR_NO'),
    	dataIndex: 'floorNo',
    	sortable:true,
    	flex: .2
    },{
    	header: getHostelTranslation('ROOM_NO'),
    	dataIndex: 'roomNo',
    	sortable:true,
    	flex: .2
    },{
    	header: getHostelTranslation('ROOM_TYPE'),
    	dataIndex: 'roomType',
    	sortable:true,
    	flex: .2
    },{
    	header: getHostelTranslation('ALLOTMENT_DATE'),
    	dataIndex: 'allotmentDate',
    	sortable:true,
    	flex: .2,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header: getHostelTranslation('ALLOTTED_BY'),
    	dataIndex: 'allottedBy',
    	sortable:true,
    	flex: .2
    },{
    	header: getHostelTranslation('STATUS'),
    	dataIndex: 'status',
    	sortable:true,
    	flex: .2
    },{
    	header: getHostelTranslation('BED_NO'),
    	dataIndex: 'bedNo',
    	sortable:true,
    	flex: .2
    },{
    	header: getCommonTranslation('DOCUMENT'),
    	dataIndex: 'documentId',
    	sortable:true,
    	flex: .2,
    	renderer:function(value,record){
    		if(!isNullOrEmpty(record.record.raw.documentId)){
    			return  '<a href="#">' +getCommonTranslation("VIEW_DETAILS") +'</a>';
    		}else
    			return "";
    	}
    },{
    	header: getHostelTranslation('CHECK_IN_DATE'),
    	dataIndex: 'checkInDate',
    	sortable:true,
    	flex: .2,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header: getHostelTranslation('CHECK_OUT_DATE'),
    	dataIndex: 'checkOutDate',
    	sortable:true,
    	flex: .2,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header : getHostelTranslation('CHECK_IN_REMARK'),
    	dataIndex : 'checkInRemark',
    	flex: .2,
    	hidden:true,
    	renderer: function(value,record){
    		if(!isNullOrEmpty(value)){
    			record.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
    			record.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;';
    			return value;
    		}
    	}
    }
    ],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.pasthistory.HosetlTrainingTypeGridStr');
    }

});