/**
 * Insurance History Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.InsuranceHistoryGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.insurancehistorygrid',
    title: getPersonModuleTranslation('INSURANCE_HISTORY'),
    border: true,
    viewConfig: {
        stripeRows: true
    },tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('INSURANCE_TYPE'),
        dataIndex: 'insuranceType',
        sortable: true,
        flex: .2
    },{
        header: getPersonModuleTranslation('INSURANCE_PROVIDER'),
        dataIndex: 'insuranceProvider',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INSURANCE_DATE'),
        dataIndex: 'insuranceDate',
        sortable: true,
        flex: .2,
        renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('SUM_INSURED'),
        dataIndex: 'sumInsured',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INSURANCE_EXPIRY_DATE'),
        dataIndex: 'insuranceExpiryDate',
        sortable: true,
        flex: .2,
        renderer:function(date) {
			return dateRender(date);
		}
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.EmployeeInsuranceHistoryStore');
    }

});