/**
 * @author priyanshi sharma
 * 
 * 
 * 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.QualificationDetailsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.qualificationdetailsgrid',    
    title: getCommonTranslation('QUALIFICATION_DETAILS'),    
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {    	     
    	var grid=this;
    	grid.addExportToolBarItems(grid);
    	var store=Ext.create('Academia.store.personinfo.common.pasthistory.QualificationDetailsGridStore');
    	Ext.apply(this, {
    		store: store        
    	});
    	this.callParent(arguments);
    	var custompagingtoolbar=grid.down('custompagingtoolbar');
    	if(custompagingtoolbar){
    		custompagingtoolbar.bindStore(store);        	
    	}
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), 
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), 
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    },{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    columns: [{
        header: getCommonTranslation('QUALIFICATION_TYPE'), 
        dataIndex: 'qualificationType',      
        flex: .5
    }, {
        header: getCommonTranslation('QUALIFICATION_CATEGORY'), 
        dataIndex: 'qualificationCategory',
        flex: .5
    }, {
        header: getCommonTranslation('EMP_QUALIFICATION_NAME'),
        dataIndex: 'qualificationName',	
        flex: .3
    }, {
        header: getCommonTranslation('MAJOR_1'),
        dataIndex: 'qualificationMajor1',
        hidden:true,
        flex: .3
    },{
        header: getCommonTranslation('MAJOR_2'),
        dataIndex: 'qualificationMajor2',
        hidden:true,
        flex: .3
    },{
        header: getCommonTranslation('MAJOR_3'),
        dataIndex: 'qualificationMajor3',
        hidden:true,
        flex: .3
    },{
        header: getCommonTranslation('HEQF_LEVEL'),
        dataIndex: 'qualificationHEQFLevel',
        hidden:true,
        flex: .3
    },{
        header: getCommonTranslation('INSTITUTION'),
        dataIndex: 'qualificationInstitution',
        flex: .5
    },{
        header: getCommonTranslation('QUALIFICATION_START_DATE'),
        dataIndex: 'qualificationStartDate',
        hidden:true,
        flex: .5,
        renderer : function(date) {
			return dateRender(date);
		}
    },{
        header: getCommonTranslation('QUALIFICATION_END_DATE'),
        dataIndex: 'qualificationEndDate',
        hidden:true,
        flex: .5,
        renderer : function(date) {
			return dateRender(date);
		}
    },{
        header: getCommonTranslation('QUALIFICATION_APPROVAL_LEVEL'),
        dataIndex: 'qualificationApprovalLevel',  
        flex: .5
    },{
        header: getCommonTranslation('QUALIFICATION_USED_IN_APPROVAL'),
        dataIndex: 'qualificationUsedInApproval',  
        hidden:true,
        flex: .5
    },{
        header: getCommonTranslation('STATUS'),
        dataIndex: 'isCompleted',  
        hidden:true,
        flex: .3,
        renderer: function(value, metadata, record) {
			var val;
			if(value==true){
				return 'Completed';
			}else if(value==false){
				return 'Incomplete';
			}
		}
    }]
});