Ext.define('Academia.view.personinfo.common.pasthistory.StudentHealthInformationReportUrlListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studenthealthinformationreporturllistgrid',
	store :'personinfo.common.pasthistory.StudentHealthInformationUrlGridStore',
	border: true,
	height:'60%',
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_URLS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.pasthistory.StudentHealthInformationUrlGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENT_URL'),
		dataIndex : 'documentName',
		sortable:false,
		flex:1,
		renderer:function(value, metaData, record){
			if(record){
				var newName=record.data.documentName;
                var newPath=record.data.path;    
                var val=!isNullOrEmpty(newName)?newName:newPath;
                return "<a href="+newPath+" target='_blank'>"+val;
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		sortable:false,
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});