/**
 * @author sachin.bangar
 * Vaccination Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.VaccinationForm', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.vaccinationform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'vaccination_hidden_field',
        name: 'id'
    },{
            xtype: 'fieldcontainer',
            name: 'version',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
    	 items:[{
    			xtype: 'customcombobox',
    			name: 'studentStatus',
    			itemId: 'studentStatusItemId',
    			store: 'student.studentprofile.StudentStatusCSMStore',
    			fieldLabel: getCommonTranslation('STUDENT_STATUS_CSM'),
    			valueField: 'id',
    			displayField: 'value',
    			//readOnly :true,
    			allowBlank: true,
    			forceSelection: true,
    			editable: false,
    			hidden: false,
    			width: 226,
    		}, {
    	        xtype: 'textfield',
    	        fieldLabel: getPersonModuleTranslation('VACCINATION_NAME'),
    	        itemId : 'vacinationNameId',
    	        labelAlign: 'top',
    	        width: 226,
    	        name: 'name',
    	        allowBlank: false
    	    }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('PURPOSE'),
            itemId : 'purpose',
            name: 'purpose',
            allowBlank: false
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('VACCINATION_DATE'),
            allowBlank: false,
            name: 'vaccinationDate',
            itemId : 'vaccinationDate',
          //--submitFormat : CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            maxValue: new Date()
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textareafield',
            name: 'remarks',
            width : 460,
            fieldLabel: getPersonModuleTranslation('REMARK')
        }]
    }, {

		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'vaccinationinfodocumentgrid',
			itemId:'vaccinationinfodocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		},
		{
			xtype:'applicantvaccinationinfodocumentgrid',
			itemId:'applicantvaccinationinfodocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		},
		{
			xtype:'employeevaccinationinfodocumentgrid',
			itemId:'employeevaccinationinfodocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },
        {
			 xtype: 'button',
			 //width:460,
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadVaccinationItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});