/**
 *  Work Experience Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.WorkExperienceGrid', {
   // extend: 'Ext.grid.Panel',
    alias: 'widget.workexperiencegrid',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    title: getPersonModuleTranslation('WORK_EXPERIENCE'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getPersonModuleTranslation('INDUSTRY'),
        dataIndex: 'industry',
        sortable: true,
        flex: .2,
        renderer : function(val){
        	if(!isNullOrEmpty(val)){
        		return val.value;
        	}else{
        		return "";
        	}
        }
    },{
        header: getPersonModuleTranslation('EMPLOYER'),
        dataIndex: 'employer',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'designation',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('DEPARTMENT'),
        dataIndex: 'department',
        sortable: true,
        flex: .2
    },{
        header: getPersonModuleTranslation('DATE_OF_JOIN'),
        dataIndex: 'joiningDate',
        sortable: true,
        flex: .2,
        renderer:function(date) {
        	return dateRender(date);
        }
    }, {
        header: getPersonModuleTranslation('DATE_OF_EXIT'),
        dataIndex: 'exitDate',
        sortable: true,
        flex: .2,
        renderer:function(date) {
        	return dateRender(date);
        }
    }, /*{
        header: getPersonModuleTranslation('EXPERIENCE_TYPE'),
        dataIndex: 'experienceType',
        sortable: true,
        flex: .2,
        renderer : function(obj) {
            return columnObjRender(obj, "value");
        }
    }, {
        header: getPersonModuleTranslation('DEPARTMENT'),
        dataIndex: 'department',
        sortable: true,
        flex: .2
    },*/ {
        header: getPersonModuleTranslation('DURATION_OF_EMPLOYMENT_MONTHS'),
        dataIndex: 'duration',
        sortable: true,
        flex: .2
    },{
        header: getPersonModuleTranslation('MODE_OF_EMPLOYMENT'),
        dataIndex: 'workType',
        sortable: true,
        flex: .2,
        renderer : function(val){
        	var msg = "";
        	if(val === 'FULL_TIME'){
        		msg = getPersonModuleTranslation('FULL_TIME');
        	}else if(val === 'PART_TIME'){
        		msg = getPersonModuleTranslation('PART_TIME');
        	}else if(val === 'PROJECT_WORK'){
        		msg = getPersonModuleTranslation('PROJECT_WORK');
        	}else if(val === 'ON_CONTRACT'){
                msg = getPersonModuleTranslation('ON_CONTRACT');
            }else if(val === 'INTERNSHIP'){
                msg = getPersonModuleTranslation('INTERNSHIP');
            }
        	return msg;
        }
    },{
        header: getPersonModuleTranslation('Area Of Expertise'),
        dataIndex: 'areaOfExpertise',
        sortable: true,
        hidden:true,
        flex: .2
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.WorkExperienceStore');
    }
});