/**
 *
 * @author priyanshi sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.GrantedCreditUnitGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.grantedcreditunitgrid',
	title: getPersonModuleTranslation('GRANTED_CREDIT_UNIT'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	initComponent: function() {    	     
		var grid=this;
		grid.addExportToolBarItems(grid);
		var store=Ext.create('Academia.store.personinfo.common.paymentandrefund.GrantedCreditUnitGridStore');
		Ext.apply(this, {
			store: store        
		});
		this.callParent(arguments);
		var custompagingtoolbar=grid.down('custompagingtoolbar');
		if(custompagingtoolbar){
			custompagingtoolbar.bindStore(store);        	
		}
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		glyph: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'program',
		flex: .2
	}, {
		header: getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex: 'batch',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('GRANTED_BY'),
		dataIndex: 'tuitionCreditGrantedByName',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('GRANTED_CREDIT_UNIT'),
		dataIndex: 'grantedCU',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('USED_CREDIT_UNIT'),
		dataIndex: 'totalUsedCU',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('AVAILABLE_CREDIT_UNIT'),
		dataIndex: 'availableCU',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('BUFFER_CREDIT_UNIT'),
		dataIndex: 'bufferCU',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('AVAILABLE_BUFFER_CREDIT_UNIT'),
		dataIndex: 'availableBufferCU',
		flex: .2
	},{
		header: getCommonTranslation('DOCUMENT'),
		dataIndex: 'documentName',
		flex: .2,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}
		}
	},{
		header: getFeeAndPaymentCommonTranslation('FROM_DATE'),
		dataIndex: 'startDate',
		hidden:true,
		flex: .2,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header: getFeeAndPaymentCommonTranslation('TO_DATE'),
		dataIndex: 'endDate',
		hidden:true,
		flex: .2,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	}]
});