/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.GrantedCreditUnitWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.grantedcreditunitwindow',
	modal: true,
	frame: true,
	maxHeight:750,
	overflowX:'hidden',
	overflowY:'auto',
	title:getFeeAndPaymentCommonTranslation('GRANTED_CREDIT_UNIT'),
	items: [{		
		xtype: 'form',
		standardSubmit: false,
		plugins:"formlabelrequired",   
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'hidden',
				itemId: 'recordId',
				name: 'recordId',
			},{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM_CODE_OR_NAME'),
				itemId: 'programId',
				name: 'program',
				store:'personinfo.common.paymentandrefund.FinancialSupportProgramStore',
				valueField: 'programId',
				displayField: 'programCodeName',
				editable : false,
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				itemId: 'bacthId',
				name: 'batch',
				store:'personinfo.common.paymentandrefund.FinancialSupportBatchStore',
				valueField: 'batchId',
				displayField: 'batchName',
				editable : false,
				allowBlank:false,
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('GRANTED_BY'),
				itemId: 'grantedById',
				name: 'grantedBy',
				store:Ext.create('Academia.store.personinfo.common.paymentandrefund.CreditUnitGrantedByStore'),
				valueField: 'id',
				displayField: 'name',
				editable : false,
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			},{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('GRANTED_CREDIT_UNIT'),
				itemId: 'grantedCreditUnitId',
				name: 'grantedCreditUnit',
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowBlank:true,
				decimalPrecision: 2,
				minValue: 0,
				maxLength: 10,
				enforceMaxLength : true,
				allowExponential: false,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT_PER_CREDIT_UNIT'),
				itemId: 'amountPerCreditUnitId',
				name: 'amountPerCreditUnit',
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowBlank:true,
				decimalPrecision: 2,
				minValue: 1,
				maxLength: 10,
				enforceMaxLength : true,
				allowExponential: false,
			},{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('AVAILABLE_CREDIT_UNIT'),
				itemId: 'availableCreditUnitId',
				name: 'availableCreditUnit',
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				decimalPrecision: 2,
				minValue: 0,
				maxLength: 10,
				enforceMaxLength : true,
				readOnly:true,
				allowExponential: false,
			}]
		},{
			xtype: 'container',
			itemId: 'dynamicRowsCUContainer',
			layout: 'vbox',
			margin: '10 0 0 0',
			defaults: {
				width: '100%'
			},
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: 'auto',
				defaults: {
					labelAlign: 'top'
				},
				items:[{
					xtype: 'numberfield',
					fieldLabel: getFeeAndPaymentCommonTranslation('CURRENTLY_USED_CU'),
					itemId: 'previouslyUsedCreditUnitId',
					name: 'previouslyUsedCreditUnit',
					width: 226,
					hideTrigger: true,
					isCurrent:true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					decimalPrecision: 2,
					minValue: 0,
					maxLength: 10,
					enforceMaxLength : true,
					allowExponential: false
				},{
					xtype: 'textfield',
					fieldLabel: getCommonTranslation('INSTITUTION_NAME'),
					itemId: 'institutionNameId',
					name: 'institutionName',
					width: 226,
					readOnly:true
				},{
					xtype: 'button',
					itemId: 'addBtn',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'30px'
					}
				}]
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('BUFFER_CREDIT_UNIT'),
				itemId: 'bufferCreditUnitId',
				name: 'bufferCreditUnit',
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowBlank:true,
				decimalPrecision: 2,
				minValue: 1,
				maxLength: 10,
				enforceMaxLength : true,
				allowExponential: false,
			},{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT_PER_BUFFER_CREDIT_UNIT'),
				itemId: 'amtPerBufferCreditUnit',
				name: 'amtPerBufferCreditUnit',
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				decimalPrecision: 2,
				minValue: 0,	
				maxLength: 10,
				enforceMaxLength : true,
				allowExponential: false,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('AVAILABLE_BUFFER_CREDIT_UNIT'),
				itemId: 'availableBuferCreditUnitId',
				name: 'availableBufferCreditUnit',
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				decimalPrecision: 2,
				minValue: 0,
				maxLength: 10,
				enforceMaxLength : true,
				readOnly:true,
				allowExponential: false,
			},{
				xtype: 'filefield',
				fieldLabel: getCommonTranslation('UPLOAD_FILE'),
				buttonText: getCommonTranslation('UPLOAD'),
				itemId: 'uploadFileItemId',
				ui: 'CustomBtnSubmit',
				name: 'file', 
				emptyText: 'Select File',
				listeners: {
					specialkey: function(me, e) {
						if (e.getKey() == e.TAB) {
							e.stopEvent();
						}
					}
				}
			},{
				xtype: 'displayfield',
				itemId: 'documentUrlId',
				name:'documentUrl',
				hidden:true,
				style:{
					marginTop:'24px !important'
				},
				width: 250,
				renderer: function (value) {
					if(value){
						return '<a href="#" class="download-doc doc-ellipsis" title="' + value + '">' + Ext.htmlEncode(value) +'</a>';
					}
				}
			},{
				xtype:'hidden',
				itemId:'encryptedDocId'
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'startDate',
				itemId:'startDateId',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				endDateField: 'endDateId',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'endDate',
				itemId:'endDateId',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				startDateField: 'startDateId',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('TO_DATE')
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}],
	listeners: {
		resize: function(win) {
			Ext.defer(function() {
				win.center();
			}, 20);
		}
	}
});
