/**
 *
 * @author priyanshi sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.ManageLoansGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageloansgrid',
	title: getPersonModuleTranslation('MANAGE_LOANS'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	initComponent: function() {    	     
		var grid=this;
		grid.addExportToolBarItems(grid);
		var store=Ext.create('Academia.store.personinfo.common.paymentandrefund.ManageLoansGridStore');
		Ext.apply(this, {
			store: store        
		});
		this.callParent(arguments);
		var custompagingtoolbar=grid.down('custompagingtoolbar');
		if(custompagingtoolbar){
			custompagingtoolbar.bindStore(store);        	
		}
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		glyph: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'btnApprove',
		text: getFeeAndPaymentCommonTranslation('APPROVE'),
		cls: 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE,
	},{
		xtype: 'button',
		itemId: 'btnReject',
		text: getFeeAndPaymentCommonTranslation('REJECT'),
		cls: 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE,
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'program',
		flex: .2
	}, {
		header: getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex: 'batch',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('FINANCIAL_INSTITUTION'),
		dataIndex: 'financialInstitution',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('AMOUNT'),
		dataIndex: 'loanAmount',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('SUBSIDY_IN_PERCENTAGE'),
		dataIndex: 'subsidy',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('LOAN_INTEREST_PER_YEAR'),
		dataIndex: 'interestRate',
		flex: .2
	},{
		header: getFeeAndPaymentCommonTranslation('TENURE_IN_MONTHS'),
		dataIndex: 'tenure',
		flex: .2
	},{
		header: getCommonTranslation('DOCUMENT'),
		dataIndex: 'documentName',
		flex: .2,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'loanStatus',
		flex: .2,
		renderer: function(value, metadata, record) {
			var val;
			if(value=='PENDING'){
				val =getCommonTranslation("PENDING");
			}else if(value=='APPROVED'){
				val =getCommonTranslation("APPROVED");
			}else if(value=='REJECTED'){
				val =getCommonTranslation("REJECTED");
			}
			return val;
		}
	},{
		header: getFeeAndPaymentCommonTranslation('LOAN_DATE'),
		dataIndex: 'loanDate',
		hidden:true,
		flex: .2,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	}]
});