/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.ManageLoansWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.manageloanswindow',
	modal: true,
	frame: true,
	title:getFeeAndPaymentCommonTranslation('LOAN_DETAILS'),
	items: [{		
		xtype: 'form',
		standardSubmit: false,
		plugins:"formlabelrequired",   
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'hidden',
				itemId: 'recordId',
				name: 'recordId',
			},{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM_CODE_OR_NAME'),
				itemId: 'programId',
				name: 'program',
				store:'personinfo.common.paymentandrefund.FinancialSupportProgramStore',
				valueField: 'programId',
				displayField: 'programCodeName',
				editable : false,
				allowBlank:false,
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			},{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				itemId: 'bacthId',
				name: 'batch',
				store:'personinfo.common.paymentandrefund.FinancialSupportBatchStore',
				valueField: 'batchId',
				displayField: 'batchName',
				editable : false,
				allowBlank:false,
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('FINANCIAL_INSTITUTION'),
				itemId: 'financialInstitutionId',
				name: 'financialInstitution',
				store:'personinfo.common.paymentandrefund.FinancialInstitutionStore',
				valueField:'id',
				editable : false,
				displayField:'name',
				allowBlank:false,
			},{
				xtype: 'textfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('LOAN_NUMBER'),
				itemId: 'loanNumberId',
				name: 'loanNumber',
			    maxLength: 50,
			    maskRe: /[A-Za-z0-9]/,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('LOAN_ACCOUNT_NUMBER'),
				itemId: 'loanAccountNumberId',
				name: 'loanAccountNumber',
			    maxLength: 50,
			    maskRe: /[A-Za-z0-9]/,
			},{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
				itemId: 'amountId',
				name: 'amount',
				allowBlank:false,
				hideTrigger: true,
			    keyNavEnabled: false,
			    mouseWheelEnabled: false,
			    allowExponential: false,
			    minValue: 1,
			    maxLength: 15,
			    decimalPrecision: 2,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('SUBSIDY_IN_PERCENTAGE'),
				itemId: 'subsidyId',
				name: 'subsidy',
				hideTrigger: true,
			    keyNavEnabled: false,
			    mouseWheelEnabled: false,
			    allowExponential: false,
			    decimalPrecision: 2,
			    minValue: 0,
			    maxLength: 10,
				enforceMaxLength : true,
			},{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('LOAN_INTEREST_PER_YEAR'),
				itemId: 'loanInterestId',
				name: 'loanInterest',
				allowBlank:false,
				hideTrigger: true,
			    keyNavEnabled: false,
			    mouseWheelEnabled: false,
			    allowExponential: false,
			    decimalPrecision: 2,
			    minValue: 0,
			    maxLength: 10,
			    enforceMaxLength : true,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('TENURE_IN_MONTHS'),
				itemId: 'tenureMonthId',
				name: 'tenureMonth',
				hideTrigger:true,
			    keyNavEnabled: false,
			    mouseWheelEnabled: false,
			    allowExponential: false,
			    allowDecimals: false,
			    allowBlank:false,
			    maxLength: 3,
			    minValue: 1,
			},{
				xtype: 'datefield',
				itemId: 'loanDateId',
				name: 'loanDate',
				allowBlank:false,
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('LOAN_DATE')
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'filefield',
				fieldLabel: getCommonTranslation('UPLOAD_FILE'),
				buttonText: getCommonTranslation('UPLOAD'),
				itemId: 'uploadFileItemId',
				ui: 'CustomBtnSubmit',
				name: 'file', 
				width: 226,
				emptyText: 'Select File',
				listeners: {
					specialkey: function(me, e) {
						if (e.getKey() == e.TAB) {
							e.stopEvent();
						}
					}
				}
			},{
				xtype: 'displayfield',
				itemId: 'documentUrlId',
				name:'documentUrl',
				hidden:true,
				style:{
					marginTop:'24px !important'
				},
				width: 250,
				renderer: function (value) {
					if(value){
						return '<a href="#" class="download-doc doc-ellipsis" title="' + value + '">' + Ext.htmlEncode(value) +'</a>';
					}
				}
			},{
				xtype:'hidden',
				itemId:'encryptedDocId'
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
