/**
 * This view is used for the student, faculty Pending Bills records.
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.OnlinePaymentGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.onlinepaymentgrid',
	title: getPersonModuleTranslation('ONLINE_PAYMENT'),
	store : 'feeandpayment.adjustment.BillReceivableApplicantHead',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox:false,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var whetherActive = record.get("whetherActive");
			if (whetherActive) {
				var baseCSSPrefix = Ext.baseCSSPrefix;
				metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
				return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			} else {
				return '';
			} 
		}	
	},
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: true
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		text:getPersonModuleTranslation('MAKE_PAYMENT'),
		tooltip: getPersonModuleTranslation('MAKE_PAYMENT')
	}],
/*	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],*/
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.adjustment.BillReceivable',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],*/
	columns: [{
		header : getFeeAndPaymentCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1,
		summaryRenderer: function(value, summaryData, dataIndex) {
            return getFeeAndPaymentCommonTranslation('TOTAL');
        }
	},{
		header : getFeeAndPaymentCommonTranslation('BILLING_DATE'),
		dataIndex : 'billHeaderBillingDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex :  1
	},{
		header : getFeeAndPaymentCommonTranslation('BILLING_AMOUNT'),
		dataIndex : 'totalAmount',
		flex :  1,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value);
		},
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.get("currencyId"))){
 				return currencyRenderer(value,record.get("currencyId"));
 			}
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'tempRemainingAmount',
		flex : 1,
		summaryType: 'sum',
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value);
		},
		renderer:function(value, metaData, record, row, col, store, gridView){
 			if(!isNullOrEmpty(record.get("currencyId"))){
 				return currencyRenderer(value,record.get("currencyId"));
 			}
 		}
		/*		renderer:function(value,meta,record){
			//if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			//}                    
		} */
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT_TO_PAY'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		summaryType: 'sum',
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value);
		},
		renderer:function(value, metaData, record, row, col, store, gridView){
 			if(!isNullOrEmpty(record.get("currencyId"))){
 				return currencyRenderer(value,record.get("currencyId"));
 			}
 		}
		/*renderer:function(value,meta,record){
			//if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			//}                    
		} */
		/*
		editing:true,
		editor : {
			xtype:'numberfield',
			name: 'totalBalanceAmount',
			itemId:'amountToBeAdjusted',
			mouseWheelEnabled:false,
			allowDecimals:true,
			enableKeyEvents:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
		*/
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
	}]
});