/**
 * Address Details
 */
Ext.define('Academia.view.personinfo.common.personalinfo.AddressDetails', {
    extend: 'Ext.form.Panel',
    alias: 'widget.addressdetails',
    title: getPersonModuleTranslation('ADDRESS'),
    closable: true,
    cls: 'panelNoSpace',
    layout: {
        type: 'vbox'
    },
    addressTemplateData: null,
    addressPersonId: null,
    items: [{
        xtype: 'panel',
        padding: 5,
        frame: false,
        width: '100%',
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SELECT_ADDRESS'),
            store: Ext.create('Academia.store.personinfo.common.personalinfo.AddressComboStore'),
            valueField: 'id',
            width: 300,
            displayField: 'value',
            value: 'SELF_ADDRESS',
            itemId: 'addressCombo',
            queryMode: 'local',
            triggerAcation: 'all',
            editable: false
        }]
    }, {
        xtype: 'addressdisplaypanel',
        itemId: 'studentAddressDisplayPanel',
        style: {
        	marginTop: '50px'
        }	
    }],
    getAddressTemplateData: function() {
        return this.addressTemplateData;
    },
    setAddressTemplateData: function(addressTemplateData) {
        this.addressTemplateData = addressTemplateData;
    },
    getAddressPersonId: function() {
        return this.addressPersonId;
    },
    setAddressPersonId: function(addressPersonId) {
        this.addressPersonId = addressPersonId;
    }
});