/**
 * This controller is used for the student, faculty address display functionality.
 * Add/Edit/print functionality
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.personinfo.common.personalinfo.AddressDisplayPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.addressdisplaypanel',
    cls: 'panelNoSpace',
//    requires: ['Ext.form.field.Display', 'Academia.view.common.AddressFieldsForm'],
    defaultType: 'displayfield',
    width: '100%',
    collapsible: false,
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        defaults: {
            width: '49%'
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'panel',
            frame: true,
            itemId:'currentAddressPanel',
            title: getPersonModuleTranslation('CURRENT_ADDRESS'),
            items: [{
                xtype: 'customAddressDisplayField',
                itemId: 'personAddressDisplayField1',
                value: getCommonTranslation('EMPTY_ADDRESS_MSG')
            }, {
                xtype: 'fieldcontainer',
                border: false,
                layout: {
                    type: 'hbox'
                },
                width: '550px',
                items: [/*{
                    xtype: 'button',
                    text: getCommonTranslation('PRINT'),
                    itemId: 'printPersonalAddress1',
                    hidden: true,
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE

                },*/ {
                    xtype: 'button',
                    text: getCommonTranslation('ADD_ADDRESS'),
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE,
                    itemId: 'modifyPersonalAddress1'
                }]
            }]
        }, {
            xtype: 'panel',
            frame: true,
            itemId:'addressForCorrespondance',
            title: getPersonModuleTranslation('ADDRESS_FOR_CORRESPONDANCE'),

            items: [{
                xtype: 'customAddressDisplayField',
                itemId: 'personAddressDisplayField2',
                value: getCommonTranslation('EMPTY_ADDRESS_MSG')
            }, {
                xtype: 'fieldcontainer',
                border: false,
                layout: {
                    type: 'hbox'
                },
                width: '550px',
                items: [/*{
                    xtype: 'button',
                    text: getCommonTranslation('PRINT'),
                    itemId: 'printPersonalAddress2',
                    hidden: true,
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE
                }, */{
                    xtype: 'button',
                    text: getCommonTranslation('ADD_ADDRESS'),
                    itemId: 'modifyPersonalAddress2',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE
                }]
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        defaults: {
            width: '49%'
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'panel',
            frame: true,
            itemId:'permanentAddressPanel',
            title: getPersonModuleTranslation('PERMANENT_ADDRESS'),
            items: [{
                xtype: 'customAddressDisplayField',
                itemId: 'personAddressDisplayField3',
                value: getCommonTranslation('EMPTY_ADDRESS_MSG')
            }, {
                xtype: 'fieldcontainer',
                border: false,
                layout: {
                    type: 'hbox'
                },
                width: '550px',
                items: [/*{
                    xtype: 'button',
                    text: getCommonTranslation('PRINT'),
                    hidden: true,
                    itemId: 'printPersonalAddress3',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE

                }, */{
                    xtype: 'button',
                    text: getCommonTranslation('ADD_ADDRESS'),
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE,
                    itemId: 'modifyPersonalAddress3'
                }]
            }]
        }, {
            xtype: 'panel',
            frame: true,
            itemId:'officeAddressPanel',
            title: getPersonModuleTranslation('OFFICE_ADDRESS'),

            items: [{
                xtype: 'customAddressDisplayField',
                itemId: 'personAddressDisplayField4',
                value: getCommonTranslation('EMPTY_ADDRESS_MSG')
            }, {
                xtype: 'fieldcontainer',
                border: false,
                layout: {
                    type: 'hbox'
                },
                width: '550px',
                items: [/*{
                    xtype: 'button',
                    text: getCommonTranslation('PRINT'),
                    itemId: 'printPersonalAddress4',
                    hidden: true,
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE
                }, */{
                    xtype: 'button',
                    text: getCommonTranslation('ADD_ADDRESS'),
                    itemId: 'modifyPersonalAddress4',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE
                }]
            }]
        }]
       },{
           xtype: 'fieldcontainer',
           width: '100%',
           defaults: {
               width: '48%'
           },
           layout: {
               type: 'hbox'
           },
           items: [{
           xtype: 'panel',
           frame: true,
           itemId:'googleAddressPanel',
           title: getPersonModuleTranslation('GOOGLE_ADDRESS'),
           items: [{
               xtype: 'customAddressDisplayField',
               itemId: 'personAddressDisplayField5',
               value: getCommonTranslation('EMPTY_ADDRESS_MSG')
           }, {
               xtype: 'fieldcontainer',
               border: false,
               layout: {
                   type: 'hbox'
               },
               width: '550px',
               items: [/*{
                   xtype: 'button',
                   text: getCommonTranslation('PRINT'),
                   itemId: 'printPersonalAddress4',
                   hidden: true,
                   ui: 'CustomBtnSubmit',
                   scale: CONSTANTS.BUTTONSIZE
               }, */{
                   xtype: 'button',
                   text: getCommonTranslation('ADD_ADDRESS'),
                   itemId: 'modifyPersonalAddress5',
                   ui: 'CustomBtnSubmit',
                   scale: CONSTANTS.BUTTONSIZE
               }]
           }]
        }]
    }]
});
