/**
 * @Author Vidhi Shah
 */
Ext.define('Academia.view.personinfo.common.personalinfo.NationalServiceDetailForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.nationalServiceDetailForm',
	border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
		xtype : 'hidden',
		itemId: 'nationalServiceUploadDocId',
		name : 'nationalServiceUploadDoc'
	},{
		xtype : 'hidden',
		itemId: 'editDocId',
		name : 'editDoc'
	},{
        xtype: 'hidden',
        itemId: 'national_Service_hidden_field',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('SERVICE_NAME'),
    		itemId : 'nationalServiceNameId',
    		store: 'common.NationalServiceNameStore',
    		valueField : 'id',
    		displayField : 'value',
    		name : 'nationalServicesId',
			forceSelection :true,
			editable : false,
			typeAhead : false,
			hideTrigger:false,
			allowBlank: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('SERVICE_ID'),
            itemId : "nationalServiceId",
            name: 'nationalServiceId',
            allowBlank: true,
            maxLength:200,
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('STATUS'),
    		itemId : 'nationalServiceStatusId',
    		store:'common.NationalServiceNamesStatusStore',
    		valueField : 'id',
    		displayField : 'value',
    		name : 'status',
			forceSelection :true,
			editable : false,
			typeAhead : false,
			hideTrigger:false,
			allowBlank: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype: 'filefield',
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText: getPersonModuleTranslation('UPLOAD'),
			itemId: 'nationalServiceDocId',
			ui: 'CustomBtnSubmit',
			name: 'file',
			width: 260,
			labelAlign: 'top',
			listeners:{
	            change: function(fileField, value) {
	                value = value.replace('C:\\fakepath\\', '');
	                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                fileField.setRawValue(newValue);
	                if (!isNullOrEmpty(newValue)) {
	                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
	                    //var allowedTypes = ['jpg','jpeg', '.png','.pdf','doc','docx'];
	                    if (!baseController.isValidProfileImageExtensionReAddmission(extension)) {
	                        fileField.reset();
	                        showWarningMessage(getCommonTranslation('ALERT'),  getPersonModuleTranslation('UPLOAD_VALID_FILE'));
	                    }
	                }
	            }
	        }
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width:500
        },
        layout: {
            type: 'hbox',
            pack: 'end'
        },
        items:[{
			xtype: 'displayfield',
			itemId: 'nationalServiceDownloadDocId',
			//hidden:true,
			//style:{'margin-left':'10px'},
			fieldStyle: 'text-align: right;',
			name:'nationalServiceDoc',
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			},
			listeners: {
				afterrender: function(c){
	    			c.getEl().on('click', function(e){
	    				if(e.target.tagName=='A') {
	    				var path = this.up('nationalServiceDetailForm').down('#nationalServiceDownloadDocId').getValue();
	    				var editDocIdpath = this.up('nationalServiceDetailForm').down('#editDocId').getValue();
	    				if(!isNullOrEmpty(path)){
							var whetherFile = false;
							var documentId= editDocIdpath;
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
						            type: 'rest',
						            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
						            method: 'GET',
						            callback : function(opt, success, response){
						            	if(response.responseText == 'true') {
						            		var csvForm = Ext.create('Ext.form.Panel'); 
						        	    	csvForm.getForm().submit({
						        		    	target: '_blank',
						        		    	method:'GET',
						        		    	params :{
						        		    		access_token : Ext.Ajax.defaultHeaders.access_token
						        		    	},
						        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
						        		    	standardSubmit :true
						        	    	});
						            	} else {
						            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
						            	}
						            }
						         });
							}} 
	    				}
	    			}, c);
	    		}
	    	}
			}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('FROM_DATE'),
			itemId : 'nationalServiceFormDateId',
            name: 'nationalServiceFormDateId',
            vtype : 'daterange',
            endDateField: 'nationalServiceToDateId',
		},{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('TO_DATE'),
			itemId : 'nationalServiceToDateId',
            name: 'nationalServiceToDateId',
            vtype : 'daterange',
			startDateField: 'nationalServiceFormDateId',
		}]
    },{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
