/**
 * @Author Ravindra Merawat 
 */
Ext.define('Academia.view.personinfo.common.personalinfo.NationalServiceGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.nationalservicegrid',
	title: getPersonModuleTranslation('NATIONAL_SERVICE'),
	border: true,
	 viewConfig: {
	        stripeRows: CONSTANTS.STRIPEROWS
	 },
	 isGridConfigurable: true,
	 enableColumnHide: false,
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getCommonTranslation('SERIAL_NUMBER'), 
		dataIndex: 'serialNo',
		sortable: true,
		flex: .2
	}, {
		header: getCommonTranslation('SERVICE_NAME'), 
		dataIndex: 'nationalServiceName',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('STATUS'), 
		dataIndex: 'status',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('SERVICE_ID'), 
		dataIndex: 'nationalServiceId',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('FROM_DATE'), 
		dataIndex: 'fromDate',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('TO_DATE'), 
		dataIndex: 'toDate',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('NATIONAL_SERVICE_DOCUMENT'),
		dataIndex: 'documentName',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			//console.log('record='+record)
			var name = record.data.documentName || "";

		    // Remove extension if present
		    var baseName = name.lastIndexOf(".") !== -1
		        ? name.substring(0, name.lastIndexOf("."))
		        : name;
					var newValue=!isNullOrEmpty(baseName) ? baseName:'';
					return '<a href=#>'+newValue+'<a>';
				} 
	}],
    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.NationalServiceStore');
    }
});