/**
 * @author Chanchal Prajapat
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentJourneyGrid', {
	 //  extend: 'Ext.grid.Panel',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.studentjourneygrid',
    title: getCommonTranslation('STUDENT_JOURNEY'),
    border : true,
	autoScroll : true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    columns: [{
       header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicTermCode',
        sortable: false,
        flex: .2,
        renderer: function(val, rec){
        	if(rec.record.data.resultStatus == "Exempt"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }
    },
    {
        header: getCommonTranslation('PERIOD_STATUS'),
        dataIndex: 'periodStatus',
        sortable: false,
        flex: .2,
		renderer:function(val,rec){
			if(rec.record.data.resultStatus == "Exempt"){
        		rec.tdCls = 'hideGridDataCls';
        	}
			
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_SELECT');
			}else{
				return getCommonTranslation(rec.record.data.periodStatus);
			}
		}
    },
    {
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academicLocationName',
        sortable: false,
        flex: .2,
		renderer:function(val,rec){
			if(rec.record.data.resultStatus == "Exempt"){
        		rec.tdCls = 'hideGridDataCls';
        	}
			var alStore = Ext.getStore('common.AcademyLocationNameSeparated');
			var recIdx = alStore.findExact('value',val);
			if(recIdx != -1){
				var alRecord = alStore.getAt(recIdx);
				rec.record.set('academicLocationId',alRecord.data.id);
			}
        	return val;
		}
    },
    {
        header: getCommonTranslation('CAMPUS'),
        dataIndex: 'campusName',
        sortable: false,
        flex: .2,
        renderer:function(val,rec){
        	if(rec.record.data.resultStatus == "Exempt"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }
    },
    {
        header: getCommonTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        sortable: false,
        flex: .2,
        renderer:function(val,rec){
        	return val;
        }
    },
    {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable: false,
        flex: .2,
        renderer:function(val,rec){
        	if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }
    },
    {
        header: getCommonTranslation('PERIOD_NAME'),
        dataIndex: 'periodName',
        sortable: false,
        flex: .2,
        renderer:function(val,rec){
        	if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }
    },
    /*{
        header: getCommonTranslation('SEAT_TYPE'),
        dataIndex: 'seatType',
        sortable: false,
        flex: .2,
        renderer:function(val,rec){
        	if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }
    },*/
    {
        header: getCommonTranslation('ENROLLMENT_STATUS'),
        dataIndex: 'resultStatus',
        sortable: false,
        flex: .2,
        /*renderer:function(val,rec){
        	if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }*/
    },
    {
        header: getCommonTranslation('PROGRESSION_STATUS'),
        dataIndex: 'progressionStatus',
        sortable: false,
        flex: .2,
        /**renderer:function(val,rec){
        	if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }*/
    },{
		header: getCommonTranslation('LIKELY_TO_RETURN'),
		dataIndex: 'likelytoReturn',
		sortable: false,
		flex: .15
	}, {
        header: getCommonTranslation('ADDED_STATUS'),
        dataIndex: 'addedStatus',
        sortable: false,
        width: 150,
        editor: {
			xtype: 'multiselectcombofield',
			name:'addedStatus',
			itemId:'addedStatus',
			store:'personinfo.common.personalinfo.StudentJourneyAddedStatusStore',
			valueField:'id',
			displayField:'value',
			editable:false,
			width: 145,
			height: 40,
			style:{
				width: '145px !important;',
				'max-width': '145px !important;',
				height: '40px !important;',
				'max-height': '40px !important;'
			},
		},
		renderer:function(val, rec){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return "";
			}else{
				if(rec.record.data.addedStatus && rec.record.data.addedStatus.length){
					if(typeof rec.record.data.addedStatus == "object" && !isNullOrEmpty(rec.record.data.addedStatus[0])){
						return Ext.Array.pluck(Ext.Array.pluck(rec.record.data.addedStatus,'data'),'value').join();
					}
					else{
						return rec.record.data.addedStatus;
					}
				}
				else{
					return "";
				}
			}
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.personalinfo.StudentJourneyStore');
    }
    
});
