/**
 * @author Suraj Chouhan
 *
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentVisaDocumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.studentvisadocumentgrid',
    store : 'personinfo.common.personalinfo.StudentVisaDocumentGridStore',
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [
	{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	
	}],
	columns :[{
		header : getCommonTranslation('DOCUMENT_NAME'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value, metaData, record){
			if(record){
				var pathSplit=record.data.path.split('/');
	            var newPath=pathSplit[2];
				var newvalue=!isNullOrEmpty(value)?value:newPath;
				return "<a href='#'>"+newvalue+"</a>";
			}
		}
	}]

});

