/**
 * @author <a href="vyabha.thakur@serosoft.in">Vyabha Thakur</a>
 *
 */
Ext.define('Academia.view.personinfo.student.StudentMOUForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentmouform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'student_mou_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'datefield',
            fieldLabel: getCommonTranslation('EFFECTIVE_START_DATE'),
            itemId: 'effectiveStartDate',
            name: 'effectiveStartDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            vtype : 'daterange',
        }]
    
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        
        items: [ {
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('AUDIT_DATE'),
            itemId: 'auditDate',
            name: 'auditDate',
            editable : false,
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
            		obj = dateFormatRender(obj);
            		obj.setValue(new Date());
            	}
            },
            allowBlank: false,
            vtype : 'daterange'
        },{
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AUDIT_ID'),            
            itemId: 'auditId',
            name: 'auditId',
            readOnly : true,
            allowBlank: false
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentmoudocumentgrid',
			itemId:'studentmoudocumentgridItemId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadStudentMOUItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
