/**
 * @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.view.personinfo.student.StudentPostGraduationDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentPostGraduationDownloadForm',
	plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype: 'customcombobox',
		fieldLabel: getCommonTranslation('TEMPLATE_IMPORT_TYPE'),
		itemId: 'templateTypePostGraduationId',
		name: 'templateTypePostGraduationId', 
		width : 226,
		store:Ext.create('Ext.data.Store', {
			fields: ['id', 'value'],
			data : [
				{"id":"IMPORT_FUNCTIONARY_DETAILS", "value":getCommonTranslation('IMPORT_FUNCTIONARY_DETAILS')},
				{"id":"IMPORT_EXAMINER_DETAILS", "value":getCommonTranslation('IMPORT_EXAMINER_DETAILS')}
				]
		}),
		valueField: 'id',
		displayField: 'value',
		forceSelection: true,
		allowBlank:false,
		labelAlign: 'top'
	},{
		xtype:'fieldcontainer',
		width: '100%',
		itemId:'programBatchPostGraduationContainerId',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'programPostGraduation',
				itemId: 'programPostGraduation',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				width:410,
				minChars:3,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
				allowBlank: false,
				typeAhead:false,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
						combo.bindStore(store);
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchNamePostGraduation',
				itemId: 'batchNamePostGraduation',
				fieldLabel: getCommonTranslation('BATCH'),
				disabled:true,
				editable: false,
				queryMode: 'local',
				displayField: 'value',
				valueField: 'id',
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					}
				},
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
						combo.bindStore(store);
					}
				}
			},{
				xtype: 'customcombobox',
				itemId:'periodPostGraduation',
				disabled:true,
				editable: false,
				displayField: 'value',
				valueField: 'id',
				queryMode: 'local',
				fieldLabel: getCommonTranslation('PERIOD'),
				name: 'periodPostGraduation',
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					}
				},
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
						combo.bindStore(store);
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('SECTION'),
				width: 226,
				labelAlign: 'top',
				name : 'sectionNamePost',
				itemId : 'sectionNamePost',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				queryMode:'local',
				forceSelection : true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					}
				},
				/*listeners: {
				render: function(combo) {
                	var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
                    combo.bindStore(store);
				}}*/
			},{
				xtype: 'button',
				itemId: 'addMoreRowBtnPost',
				cls: 'CustomBodyBtnSettings mtAddRow',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				}
			}]
		}]},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			items:[{
				xtype: 'fieldcontainer',
				width: 'auto',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('DOWNLOAD_TEMPLATE'),
					itemId: 'StdPostLoaderDownload',
					formBind: true,
					ui: 'CustomBtnSubmit'
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'resetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]}]});
