/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementJobApplicationApplyJobGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementjobapplicationapplyjobgrid',
	store: 'placement.placementjobapplication.PlacementJobApplicationGetStudentGridStore',
	title:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_LIST_OF_STUDENT'),
	border: true,
	autoScroll: false,
	frame:false,
	selType:'checkboxmodel',
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementjobapplication.PlacementJobApplicationGetStudentGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		text: getPlacementTranslation('APPLY'),
		itemId: 'applyApplication',

	}],
	columns: [{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	}]
});

