/**
 * @author Amit G
 */
Ext.define('Academia.view.program.OutcomeBasedEducationGrid.CreateExamEventDetailsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.createexameventdetailsgrid',
    store: 'program.ExamEventQuestionDetailsStore',
    title: getExaminationTranslation('MANAGE_QUESTIONS'),
    border: true,
    //autoScroll:true,
    frame: false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		formBind :true
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SAVE'),
			itemId: 'SaveBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind :true
		}]
		
	},{
		xtype: 'button',
		text: getExaminationTranslation('IMPORT_QUESTIONS'),
		itemId: 'importQuestionItemId',
		//ui: 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE,
		formBind :true
	}],
	 initComponent: function() {
	        var grid = this;
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);
	    },
    columns: [{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		dataIndex: 'rownumberer',
		align :'left',
		flex: 0.1
	},{
        header: getExaminationTranslation('QUESTIONS_NUMBER'),
        dataIndex: 'questionNumber',
        flex: 0.5,
        sortable: false,
        editor: {
        	xtype: 'textfield',
        	name: 'questionNumber',
        	itemId:'questionNumber',
        	width:50,
        	minValue:0,
        	maxLength: 255,
        	allowBlank:false,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'questionNumber',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
        
    },{
        header: getExaminationTranslation('MAXIMUM_MARKS'),
        dataIndex: 'maxMarks',
        flex: 0.5,
        sortable: false,
        editor: {
        	xtype: 'numberfield',
        	name: 'maxMarks',
        	itemId:'maxMarks',
        	width:50,
        	minValue:0,
        	maxLength: 6,
        	enforceMaxLength : true,
        	keyNavEnabled: true,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:true,
        	decimalPrecision: 2,
        	itemId: 'maxMarks',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    }, {
        header: getExaminationTranslation("BLOOM_TAXONOMY_LEVEL"),
        dataIndex: 'bloomsTaxonomyId',
        flex: 0.5,
        sortable: false,
        editor: {
            xtype: 'customcombobox',
            name: 'taxonomyLevel',
            itemId: 'taxonomyLevelItemId',
            store: Ext.create('Academia.store.exam.OutcomeBasedEducation.TaxonomyLevelStore'),
            valueField: 'id',
            displayField: 'flagCode',
            editable: false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{flagCode}' +
                        '</div>';
                }
            }
        },
        renderer: function (value, rec, record, rowIndex, colIndex, store, view) {
        	if(isNullOrEmpty(view.up('grid').bloomLevelStore)) {
        		view.up('grid').bloomLevelStore = rec.column.getEditor().getStore();
        	}
            if (!isNullOrEmpty(value) && value !== '') {
                try {
                	var comboStore = view.up('grid').bloomLevelStore;
                	var rec = comboStore.findRecord('id', value, 0, false, true, true);
                	if (rec) {
                		record.set('bloomsTaxonomyId', value);
                        return rec.get('flagCode');
                    } else {
                        return value;
                    }
                } catch (e) {
                    return null;
                }
            } else {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            }
        }
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: false,
        renderer: function(value, meta, record) {
            if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: false,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        		if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
                    return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
                }	
            return '';
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
});
