/**
 * @author Amit G
 */
Ext.define('Academia.view.program.OutcomeBasedEducationGrid.MapCourseOutComeGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.mapcourseoutcomegrid',
    store: 'program.ManageCourseOutcomeStore',
    title: getProgramandcourseTranslation('LIST_OF_COURSE_OUTCOMES'),
    border: true,
    autoScroll:false,
    frame: false,
    hidden:true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.ManageCourseOutcomeStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		disabled:true
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			itemId: 'SaveBtn',
			ui: 'CustomBtnSubmit',
			text: getCommonTranslation('SAVE'),
			disabled:true
		}]
		
	}],
	 initComponent: function() {
	        var grid = this;
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);
	    },
    /*initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        grid.callParent(arguments);
    },*/
    columns: [{
        header: getProgramandcourseTranslation('COURSE_OUTCOME_CODE'),
        dataIndex: 'courseOutComeCode',
        flex: 0.5,
        sortable: false,
        editor: {
        	xtype: 'textfield',
        	name: 'courseOutComeCode',
        	width:50,
        	minValue:0,
        	maxLength: 15,
        	allowBlank:false,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'courseOutComeCode',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
        
    },{
        header: getAdmissionTranslation('DESCRIPTION'),
        dataIndex: 'description',
        flex: 0.5,
        sortable: false,
        editor: {
        	xtype: 'textfield',
        	name: 'description',
        	width:50,
        	minValue:0,
        	maxLength: 500,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'description',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: false,
        renderer: function(value, meta, record) {
            if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.manageCourseOutComeId))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.2,
        
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: false,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        		if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.manageCourseOutComeId)) {
                    return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
                }	
            return '';
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
    	beforeedit: function(editor, context) {
    		if(editor.context.field=='courseOutComeCode'){
    			if(!isNullOrEmpty(context.record.data.id)){
    				context.grid.columns[0].getEditor().setReadOnly(true);
    				return context.colIdx !== 0;
    			}else{
    				context.grid.columns[0].getEditor().setReadOnly(false);
    			}

    		}else if(editor.context.field=='description'){
    			if(!isNullOrEmpty(context.record.data.courseOutComeCode)){
    				context.grid.columns[1].getEditor().setReadOnly(false);
    				return context.colIdx !== 0;
    			}else{
    				context.grid.columns[1].getEditor().setReadOnly(true);
    			}

    		}
    	}
	}/*,
    getAllSelectedSalesStaffIdsSanctioning: function(combo){
    	var ids = [];
    	this.getStore().each(function(rec){
    		if(combo.getValue()!=rec.get('staffId') && !isNullOrEmpty(rec.get('staffId'))){
    			ids.push(rec.get('staffId'));
    		}
    	});
    	return ids.join();
    }*/
});
