Ext.define('Academia.view.program.OutcomebasededucationFilter.ManageProgramOutcomesFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.manageprogramoutcomesfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'vbox',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items :[
				{
					xtype:'hidden',
					name:'id'
				},{
					xtype: 'customcombobox',
					name: 'program',
					width:460,
					itemId: 'programId',
					fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//					translationKey: 'PROGRAM',
					store:'common.ProgramStore',
					displayField:'valueCode',
					valueField:'id',
					allowBlank:false,
					typeAhead : true,
			        forceSelection:true,
			        hideTrigger:false,
			        //queryMode: 'local',	    
				    triggerAction: 'all',
				    //anyMatch : true,
				    queryParam:'programName',
				    minChars:3,
			        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			        listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{value}'  +
			                    '</div>';
			                }
			            }
				},{
					xtype: 'customcombobox',
					name: 'batchId',
					fieldLabel: getProgramandcourseTranslation('BATCH'),
					itemId:'batchId',
					store: 'common.BatchStore',
					valueField: 'id',
					displayField: 'value',
					disabled:true,
					allowBlank:false,
					typeAhead:true,
					forceSelection:true
				}
			]
		},{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width:226
				},
				items :[{
					xtype : 'customcombobox',
					fieldLabel : getProgramandcourseTranslation('PROGRAM_OUTCOME_TYPE'),
					name : 'outcomeId',
					itemId:'outcomeId',
					store: 'Academia.store.OBECorrelationLevelStore.OBECorrelationLevelStore',
					valueField: 'id',
					displayField: 'code',
					disabled:true,
					allowBlank:false,
					typeAhead:true,
					forceSelection:true					
				}]
			}],
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'mapProgramOutcomeSearchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind :true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'mapProgramOutcomeResetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:false
			}]
		}]
});

