/**
 * @Author Akshay Sharma
 */
Ext.define('Academia.view.program.StudentSpecialEnrollmentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentspecialenrollmentgrid',
	store : 'program.SpecializationEnrollmentGridStore',
	title: getCommonTranslation('STUDENT_LIST'),
	border: true,
	temp :[],
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.SpecializationEnrollmentGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar: [{
		xtype : 'button',
		itemId:'enrollSpecializationBtn',
		text : getProgramandcourseTranslation('ENROLL_SPECIALIZATION'),
		tooltip :getProgramandcourseTranslation('ENROLL_SPECIALIZATION')
	},{
		xtype: 'button',
		text:getProgramandcourseTranslation('APPROVE'),
		itemId:'spclApproveBtn',
		tooltip :getProgramandcourseTranslation('APPROVE')
	},{
		xtype: 'button',
		text:getProgramandcourseTranslation('CHANGE_SPECIALIZATION'),
		itemId:'spclChangeBtn',
		tooltip :getProgramandcourseTranslation('CHANGE_SPECIALIZATION')
	
	},'->'],
	columns : [{
		header :getProgramandcourseTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header :getProgramandcourseTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex:1,	
		renderer:function(value,meta,record){
					if(isNullOrEmpty(value)){
						return value;
					} else {
						return '<a href=#>'+value+'</a>'
					}
				}
	},{
		header : getProgramandcourseTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getProgramandcourseTranslation('SPECIALIZATION'),
		dataIndex : 'specializationCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	},{
       header : getProgramandcourseTranslation('REQUEST_DATE'),
       dataIndex : 'requestDate',
       flex:1
    },{
       header : getProgramandcourseTranslation('APPROVED_BY'),
       dataIndex : 'approveBy',
       flex:1
    },{
       header : getProgramandcourseTranslation('APPROVAL_DATE'),
       dataIndex : 'approvedDateString',
       flex:1
    }]
});
