/**
 * @author shivam
 */
Ext.define('Academia.view.program.lessonplanning.LessonplanBulkCopyWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.lessonplanbulkcopywindow',
	modal: true,
	autoScroll:true,
	title: getProgramandcourseTranslation('BULK_COPY_LESSON_PLAN'),
	maxHeight:500,
	width: '40%',
	items: [{
		xtype: 'form',
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 260
			},
			items: [{
				xtype: 'customcombobox',
				name: 'academicLocation',
				itemId : 'academicLocationId',
				fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
	        	displayField : 'value',
	        	valueField : 'id',
	        	allowBlank:false,
				typeAhead:true,
				editable : false,
				style:{
					marginBottom:'15px'
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}
				
			},{
				xtype: 'customcombobox',
				name: 'academicTerm',
				itemId : 'academicTermId',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store:'common.AcademicTermStore',
	        	displayField : 'value',
	        	valueField : 'id',
	        	allowBlank:false,
				typeAhead:true,
				editable : false,
				style:{
					marginBottom:'15px'
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}
				
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('COPY'),
				itemId: 'btnCopy',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				handler :function(button) {
                	button.up('window').close();
                }
			}]	
		}]
	}]
});