Ext.define('Academia.view.program.programDetails.pathwaysEnrollment.PathwaysApproveRejectWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.pathwaysApproveRejectWindow',
	autoScroll: true,
//	title:getCommonTranslation('REJECTION_REMARKS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	closeAction: 'destroy',
	items: [{
		xtype: 'form',
		//bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
			xtype: 'textareafield',
			name: 'commentReject',
			itemId:'commentReject',
			width: 460,
			fieldLabel: getCommonTranslation('REJECTION_REMARKS'),
			allowBlank: false,
			listeners: {
		        change: function (field, newVal) {
		            var win = field.up('window'),
		                rejectBtn = win.down('#rejectBtn'),
		                saveBtn = win.down('#submitBtn');

		            rejectBtn.setDisabled(Ext.isEmpty(newVal));
		            saveBtn.setDisabled(Ext.isEmpty(newVal));
		        },
		        keyup: function (field) {
		            field.fireEvent('change', field, field.getValue());
		        }
		    }

		},{
			xtype: 'textareafield',
			name: 'commentApprove',
			itemId:'commentApprove',
			width: 460,
			fieldLabel: getCommonTranslation('APPROVE_REMARK'),
			allowBlank: false,
			listeners: {
		        change: function (field, newVal) {
		            var win = field.up('window'),
		                rejectBtn = win.down('#rejectBtn'),
		                saveBtn = win.down('#submitBtn');

		            rejectBtn.setDisabled(Ext.isEmpty(newVal));
		            saveBtn.setDisabled(Ext.isEmpty(newVal));
		        },
		        keyup: function (field) {
		            field.fireEvent('change', field, field.getValue());
		        }
		    }

		},{	
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				disabled: true,
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('REJECT'),
				itemId: 'rejectBtn',
				disabled: true,
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE,
				listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
				}
			}]
		}]  
	}]	
});