Ext.define('Academia.view.program.programDetails.pathwaysEnrollment.PathwaysEnrollmentFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.pathwaysEnrollmentFilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'radiogroup',
		itemId: 'requestFor',
		name:'REQUEST_FOR',
		layout:'hbox',
		items: [{
			boxLabel: getServiceRequestTranslation('All_REQUESTS'),
			name: 'requestFor',
			itemId:'allRequest',
			inputValue: 'All_REQUESTS',
			checked: true,
			margin:'0 20 0 0',
			style: 'font-weight: bold;'

		},{
			boxLabel: getServiceRequestTranslation('MY_REQUESTS'),
			name: 'requestFor',
			itemId:'myRequest',
			inputValue: 'MY_REQUESTS',
			margin:'0 20 0 0',
			style: 'font-weight: bold;'
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[
			{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name: 'programId',
				itemId: 'programId',
				store : 'program.ProgramSortedSequenceWiseStore',
				displayField: 'valueCode',
				valueField: 'id',
				minChars:3,
				allowBlank:false,
				forceSelection:true,
				queryParam:'qry',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('BATCH'),
				name: 'batchId',
				itemId: 'batchId',
				editable: false,
				allowBlank:false,
				disabled: true,
				store:'program.programbatchdetail.BatchStore',
				displayField: 'value',
				valueField: 'id',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{

				xtype: 'customcombobox',
				width: 226,
				name: 'period',
				itemId: 'period',
				editable:true,
				fieldLabel : getAdmissionTranslation('PERIOD'),
				store:Ext.create('Academia.store.program.SpecialiazedPeriodStore'),
				displayField:'value',
				valueField:'id',
				autoloadStore: false,
				allowBlank:false,
				disabled: true,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
							Ext.defer(function() {
								picker.getEl().dom.style.wordBreak='break-all';
							},200);
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[
			{
				xtype: 'customcombobox',
				fieldLabel: getProgramandcourseTranslation('PATHWAYS'),
				name: 'pathways',
				itemId: 'pathways',
				store : 'program.programDetails.programBatches.pathwaysConfig.PathwaysFilterStore',
				displayField: 'value',
				valueField: 'value',
				minChars:3,
//				allowBlank:false,
				forceSelection:true,
				disabled: true,
				queryParam:'qry',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}, {
				xtype: 'combo',
				name: 'status',
				itemId: 'statusId',
				fieldLabel: getProgramandcourseTranslation('STATUS'),
				disabled: false,
				valueField: 'id',
				displayField: 'id',
				typeAhead: true,
				forceSelection: true,
				queryMode: 'local',
				store:['Pending','Assigned','Approved']
			}, {


				xtype: 'customcombobox',
				name:'studentNameSearch',
				itemId: 'studentNameSearchId',
				width:450,
				fieldLabel: getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
				store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameStudentIdBySmartSearch',
				valueField: 'secondId',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
//				disabled:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}





			/*

				xtype: 'multiselectcombofield',
				width: 300,
				name: 'period',
				itemId: 'period',
				editable:true,
				fieldLabel : getAdmissionTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
				store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
				displayField:'value',
				valueField:'id',
				autoloadStore: false,
				allowBlank:false,
				disabled: true,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
							Ext.defer(function() {
								picker.getEl().dom.style.wordBreak='break-all';
							},200);
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			 */}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		items:[{  
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'btnSearch',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true

		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'btnReset',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]
	}]
});