Ext.define('Academia.view.program.programDetails.pathwaysEnrollment.PathwaysEnrollmentGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.pathwaysEnrollmentGrid',
	store : 'pathways.PathwaysEnrollmentGridStore',
	title: getProgramandcourseTranslation('PATHWAYS_ENROLLMENT'),
	border: true,
	refreshStoreData:true,
//	selType :'checkboxmodel',
    itemId: 'pathwaysEnrollmentGridId',
	/*selModel: {
//		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},*/
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'coursesectionmanagementstructure':1
		}
	},*/
	dockedItems : [ {
		itemId:'dockedItemsItemId',
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'pathways.PathwaysEnrollmentGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		text:getProgramandcourseTranslation('ENROLL_PATHWAYS'),
		itemId:'enrollPathwaysBtn',
		tooltip :getProgramandcourseTranslation('ENROLL_PATHWAYS'),
//		disabled:true
	},{
		xtype: 'button',
		text:getProgramandcourseTranslation('APPROVE'),
		itemId:'enrollPathwaysApproveBtn',
		tooltip :getProgramandcourseTranslation('APPROVE'),
//		disabled:true
	},{
		xtype: 'button',
		text:getCommonTranslation('REJECT'),
		itemId:'enrollPathwaysRejectBtn',
		tooltip :getCommonTranslation('REJECT'),
//		disabled:true
	},'->'],
	columns: [{
		header : getCommonTranslation('REQUEST_ID'),
		dataIndex : 'requestId',
		flex : 1
	},
	{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1,
		renderer:function(value){
   		 if(value){
			    return  '<a href="#">'+ value + '</a>';
   		 }
   	 }
	},
	{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1
	},{
		header : getProgramandcourseTranslation('PATHWAYS'),
		dataIndex : 'patwaysName',
		flex : 1
	},{
		header : getProgramandcourseTranslation('CURRENT_ASSIGNEE'),
		dataIndex : 'currentAssignee',
		flex : 1
	},{
		header : getCommonTranslation('CURRENT_STATUS'),
		dataIndex : 'status',
		flex : 1
	},{
		header : getProgramandcourseTranslation('ASSIGNED_DATE'),
		dataIndex : 'assignedDateString',
		flex : 1
	},{
		header : getProgramandcourseTranslation('REQUEST_DATE'),
		dataIndex : 'requestDate',
		flex : 1
	},{
		header : getCommonTranslation('APPROVED_BY'),
		dataIndex : 'approveBy',
		flex : 1
	},{
		header : getCommonTranslation('APPROVED_DATE'),
		dataIndex : 'approvedDateString',
		flex : 1
	},{
		header : getCommonTranslation('REMARKS'),
		dataIndex : 'remarkNumber',
		flex : 1,
		renderer:function(value){
    		 if(value){
			    return  '<a href="#">'+ getHostelTranslation('VIEW') + '</a>';
    		 }
    	 }
	}]
});
