/**
 * sumit
 */

Ext.define('Academia.view.program.programDetails.programBatchDetails.courseParameters.ProgramBatchCourseParameterForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.programbatchcourseparameterformwindow',
	modal: true,
//	autoScroll:true,
	height:500,
	overflowX : 'hidden',
	overflowY : 'auto',
	title : getCommonTranslation('COURSE_PARAMETER'),
	closeAction : 'destroy',
	items: [{
		xtype: 'dynamicfieldformwin',
		itemId: 'programBatchCourseParameterFormWindowItemId',
		//id:'programBatchCourseItemId',
		method: 'POST',
		autoScroll:false,
		margin: 0,
		bodyPadding: '10 10 10 10',
		/* layout: {
            type: 'vbox'
        },*/
		defaults: {
			labelAlign: 'top',
			autoScroll:false
		},
		plugins:"formlabelrequired",
		standardSubmit: false,

		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
				xtype:'hidden',
				name:'id'
			},{
				xtype:'hidden',
				name:'courseVariantCodeId'
			},{
				xtype:'hidden',
				name:'version'
			},{
				xtype:'hidden',
				name:'paramterizationDate'
			},{
				xtype:'hidden',
				name:'courseMarksGrades',
				itemId:'courseMarksGrades_Id'
			},{
				xtype:'hidden',
				name:'whetherRegularCourse',
				itemId:'whetherRegularCourse'
			},{
				xtype: 'customcombobox',
				name: 'programPeriodNameId',
				itemId:'programPeriodNameIdItemId',
				fieldLabel: getCommonTranslation('SELECT_PERIOD'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank: false,
				queryMode:'local',
				typeAhead: true,
				anyMatch: true
			},{
				xtype : 'customcombobox',
				name : 'academicTerm',
				itemId : 'academicTerm',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store : 'common.AcademicTermStore',
				valueField : 'id',
				displayField : 'value',
				forceSelection:true,
				allowBlank: false,
				queryMode:'local',
				typeAhead: true,
				anyMatch: true
			},{
				xtype: 'customcombobox',
				name: 'sectionCodeId',
				itemId : 'paramSectionId',
				editable:false,
				fieldLabel: getCommonTranslation('SELECT_SECTION'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCourseSection',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				allowBlank: false
			}]
		}, {
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
				xtype: 'numberfield',
				name: 'courseEvaluationTotal',
				hideTrigger:true,
				minValue : 0,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				fieldLabel: getCommonTranslation('COURSE_EVALUATION_INTERNAL_TO_TOTAL'),
				allowBlank: true,
				hidden:true

			},{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('MAKE_THIS_PROGRAM_AS_PRIMARY'),
				//itemId: 'radioId',
				hidden:true,
				name:'whetherPrimary',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items: [
					{
						boxLabel  :getCommonTranslation('YES') ,
						name      : 'whetherPrimary',
						inputValue: true
					}, {
						boxLabel  : getCommonTranslation('NO'),
						name      : 'whetherPrimary',
						inputValue: false
					}
					]
			}]
		}
		,/*{
    			xtype: 'fieldcontainer',
        		width:'100%',
        		layout: {
        			type: 'vbox'
        		},
        		defaults :{
        			width: 226,
        			labelAlign:'top'
        		},
                items :[*/
		{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[
				{
					xtype:'numberfield',
					fieldLabel: getCommonTranslation('SECTION_MIN_ENROLLMENT'),
					itemId:'minSection_Id',
					name: 'minSectionEnrollment',
					minValue : 0,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:false,
					validateOnBlur: true,
					allowBlank: false,
					validator : function(val) {
						var maxValuefield = Ext.ComponentQuery.query('numberfield#maxSection_Id')[0];
						var maxValue = maxValuefield.getValue();
						if (maxValue != null) {
							if (val <= maxValue) {
								return true;
							} else {
								return 'Less than or equal of max section';
							}
						} else {
							return true;
						}
					}
				}, {
					xtype:'numberfield',
					fieldLabel: getCommonTranslation('SECTION_MAX_ENROLLMENT'),
					itemId:'maxSection_Id',
					name: 'maxSectionEnrollment',
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowDecimals:false,
					validateOnBlur: true,
					allowBlank: false,
					validator : function(val) {
						var me = this;
						var minValueField = Ext.ComponentQuery.query('numberfield#minSection_Id')[0];
						var minValue = minValueField.getValue();
						var maxValue = me.maximumValue;
						if(isNullOrEmpty(minValue)){
							minValue = 0;
						}
						if (minValue != null) {
							if (val < minValue || val > maxValue) {
								if(val < minValue){
									return 'This field value should be greater than '+minValue;
								}
								else if(val > maxValue){
									return 'This field value should be less than '+maxValue;
								}
							} else {
								minValueField.clearInvalid();
								me.clearInvalid();
								return true;
							}
						} else {
							return true;
						}
					},
					listeners: {
						validitychange: function(field, isValid, eOpts){
							setTimeout(function(){
								field.isValid();
							},100);
						}
					}
				}]
		},
//		]}
		{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('STUDENT_CAN_WITHDRAWN_ONCE_THE_COURSE_IS_COMMENCED'),
				name:'canStudentWithdraw',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items: [
					{
						boxLabel  :getCommonTranslation('YES'),
						name      : 'canStudentWithdraw',
						inputValue: true
					}, {
						boxLabel  : getCommonTranslation('NO'),
						name      : 'canStudentWithdraw',
						inputValue: false
					}
					]
			},
			{
				xtype: 'customcombobox',
				name:'approverId',
				store: 'common.AllUserBySmartSearch',
				fieldLabel : getCommonTranslation('APPROVER_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				allowBlank: true,
				typeAhead:false,
				hideTrigger:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			width:350,
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 300,
				labelAlign:'top'
			},
			items:[{ 
				xtype: 'checkboxfield',
				name: 'isEnrollmentBasedOnCourseCategory',
				itemId:'isEnrollmentBasedOnCourseCategoryId',
				boxLabel: getCommonTranslation('IS_ENROLLMENT_BASED_ON_COURSE_CATEGORY'),
				width: 'auto',
				labelAlign: 'right',
				hideTrigger :true,
				inputValue : true,
				uncheckedValue: false 
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
	      	     	  xtype      : 'radiogroup',
	      	          fieldLabel : getProgramandcourseTranslation('GRADE_IMPROVEMENT_RE_APPEAR'),
	      	          itemId: 'gradeImprovementReAppearId',
	      	          name:'gradeImprovementReAppear',
	      	          defaults: {
	      	              flex: 1
	      	          },
	      	          layout: 'hbox',
	      	          items: [{
	      	                  boxLabel  :getCommonTranslation('YES') ,
	      	                  name      : 'gradeImprovementReAppear',
	      	                  inputValue: true
	      	              },{
	      	                  boxLabel  : getCommonTranslation('NO'),
	      	                  name      : 'gradeImprovementReAppear',
	      	                  inputValue: false,
	      	                  checked:true
	      	              }]
	      	      }
			]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
	      	     	  xtype      : 'radiogroup',
	      	          fieldLabel : getProgramandcourseTranslation('TUTION_GRANT_APPLICABLE'),
	      	          itemId: 'tuitionGrantApplicableId',
	      	          name:'tuitionGrantApplicable',
	      	          defaults: {
	      	              flex: 1
	      	          },
	      	          layout: 'hbox',
	      	          items: [{
	      	                  boxLabel  :getCommonTranslation('YES') ,
	      	                  name      : 'tuitionGrantApplicable',
	      	                  inputValue: true
	      	              },{
	      	                  boxLabel  : getCommonTranslation('NO'),
	      	                  name      : 'tuitionGrantApplicable',
	      	                  inputValue: false,
	      	                  checked:true
	      	              }]
	      	      }
			]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
	      	     	  xtype      : 'radiogroup',
	      	          fieldLabel : getProgramandcourseTranslation('GOVT_SUBSIDY_APPLICABLE'),
	      	        itemId: 'govtSubsidyApplicableId',
	      	          name:'govtSubsidyApplicable',
	      	          defaults: {
	      	              flex: 1
	      	          },
	      	          layout: 'hbox',
	      	          items: [{
	      	                  boxLabel  :getCommonTranslation('YES') ,
	      	                  name      : 'govtSubsidyApplicable',
	      	                  inputValue: true
	      	              },{
	      	                  boxLabel  : getCommonTranslation('NO'),
	      	                  name      : 'govtSubsidyApplicable',
	      	                  inputValue: false,
	      	                  checked:true
	      	              }]
	      	      }
			]
		},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('MORE_DETAILS'),
			titleCollapse: true,
			name: 'courseMarkGradeMoreDetails',
			itemId:'courseMarkGradeMoreDetailsItemId',
			margin: '0 0 0 -5',
			padding: '0 0 0 0',
			width: '100%',
			style: {
				marginTop: '33px!important'
			},
			items: [{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items:[{
					xtype: 'numberfield',
					itemId:'courseOff_id',
					name: 'courseCutOff',
					fieldLabel: getCommonTranslation('COURSE_MINIMUM_PASSING_MARKS'),
					minValue : 0,
					minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
					hidden:true,
					allowBlank:false,
					validator : function(val) {
						var maxValuefield = this.nextSibling();
						var maxValue = maxValuefield.getValue();
						if (maxValue != null) {
							if (val <= maxValue) {
								maxValuefield
								.clearInvalid();
								return true;
							} else {
								return getCommonTranslation('LESS_THAN_MAX_VALUE');
							}
						} else {
							return true;
						}
					}
				},{    
					xtype: 'numberfield',
					itemId:'courseMaxMarks_Id',
					name: 'courseMaxMark',
					fieldLabel: getCommonTranslation('COURSE_MAXIMUM_PASSING_MARKS'),
					minValue : 1,
					minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
					hidden:true,
					allowBlank:false,
					validator : function(val) {
						var minValueField =this.previousSibling();
						var minValue = minValueField
						.getValue();
						if (minValue != null) {
							if (val >= minValue) {
								minValueField
								.clearInvalid();
								return true;
							} else {
								return getCommonTranslation('MORE_THAN_MIN_VALUE');
							}
						} else {
							return true;
						}
					}
				}]
			},
			{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items:[{
					xtype: 'customcombobox',
					itemId:'courseMax_1',
					fieldLabel : getCommonTranslation('COURSE_GRADES'),
					name:'courseMaxMarkCombo',
					store:'course.CourseGradeStore',
					displayField: 'value',
					valuefield:'value',
					hidden:true,
					allowBlank:false
				},{
					xtype: 'customcombobox',
					itemId:'courseOff_1',
					//fieldLabel : getCommonTranslation('COURSE_PASS_CUT_OFF'),
					fieldLabel : getCommonTranslation('COURSE_MINIMUM_PASSING_GRADE'),
					name:'courseCutOffComboMin',
					store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
					displayField: 'gradeName',
					valuefield:'gradeName',
					hidden:true,
					forceSelection:true,
					allowBlank:false
				}]
			},

			{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items:[{
					xtype: 'customcombobox',
					itemId:'courseOff_2',
					fieldLabel : getCommonTranslation('COURSE_MAXIMUM_PASSING_GRADE'),
					name:'courseCutOffComboMax',
					store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
					displayField: 'gradeName',
					valuefield:'gradeName',
					forceSelection:true,
					hidden:true,
					allowBlank:false
				},{	
					xtype : 'numberfield',
					name: 'courseCredits',
					itemId:'courseCredit_Id',
					fieldLabel: getCommonTranslation('COURSE_CREDITS'),
					minValue : 0,
					allowDecimals:true,
					decimalPrecision: 2,
					allowBlank:false
				}
				]
			},
			{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items:[{	
					xtype : 'numberfield',
					name: 'billingCreditHours',
					itemId:'billingCreditHours_Id',
					fieldLabel: getCommonTranslation('BILLING_CREDIT_HOURS'),
					minValue : 0,
					maxValue :999,
					maxLength:5,
					enforceMaxLength : true,
					allowDecimals:true,
					decimalPrecision: 2,
				},{
					fieldLabel: getCommonTranslation('COURSE_SEQUENCE'), 
					xtype: 'numberfield',
					itemId: 'courseSequenceId',
					name: 'courseSequence',
					minValue: 0,
					labelAlign: 'top',
					style:{marginBottom:'2px'},
					allowExponential :false,
					allowDecimals: false,
					mouseWheelEnabled:false,
					hideTrigger: true,
					decimalPrecision: 2

				},
		  		{
					xtype:'displayfield',
					style: 'margin-left: -5px; margin-top:26px; margin-right: 10px;',
					name:'maximumCreditMsg',
					width:'auto',
					hidden:true	
				}]
			},
			{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items:[{	
					xtype: 'customcombobox',
					itemId:'courseCategoryCombo',
					fieldLabel: getCommonTranslation('COURSE_CATEGORY'),
					name:'courseCategoryCombo',
					store:Ext.create('Academia.store.course.CourseCategoryStore'),
					displayField:'value',
					valueField:'id',
					forceSelection:true,
					allowBlank:true
				},{
                	 xtype: 'customcombobox',
                     name: 'courseType',
                     fieldLabel: getCommonTranslation('COURSE_TYPE'),
                     value:true,
                     store: 'common.CourseTypeStore',
                     itemId: 'courseTypeId',
                     valueField: 'value',
                     displayField: 'name'
                } ]
			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'50%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
				    xtype: 'numberfield',
				    name: 'weightGPA',
					itemId: 'weightGPA',
				    fieldLabel: getCommonTranslation('WEIGHT_GPA'),
				    allowDecimals: true,
				    hidden: true,
				    editable: true,
				    minValue:0,
				    maxValue :999999,
				    decimalPrecision: 2, // for display purposes only
				    validator: function(value) {
				        if (value === '' || value === null) {
				            return true; // allow blank if required
				        }

				        // Check if the value has more than 2 decimal digits
				        var parts = value.toString().split('.');
				        if (parts.length === 2 && parts[1].length > 2) {
				            return 'Only up to two decimal places are allowed.';
				        }
				        return true;
				    }
				}
				]}
			]
	    },
		{
			xtype: 'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action : 'Submit',
				formBind: true,
				text: getCommonTranslation('SAVE'),
				itemId: 'programCourseParameterFormSubmit',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'programCourseParameterFormCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});