Ext.define('Academia.view.program.programDetails.programBatchDetails.courseParameters.ViewFacultyGrid', {
    extend : 'Ext.grid.Panel',
    alias : 'widget.viewfacultygrid',
    store : 'program.programDetails.programBatches.courseParameter.FacultyData',
    title : getCommonTranslation('FACULTY_LIST'),
    border: true,	
    autoScroll: false,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    columns : [{
	    header :getCommonTranslation('FACULTY_PRINT_NAME'),
	    dataIndex : 'facultyName',
	    flex : .1,
	    renderer : function(value,records) {
			if(!isNullOrEmpty(records.record.data.facultyCode) && !isNullOrEmpty(records.record.data.facultyName)){
				return records.record.data.facultyCode+"/"+records.record.data.facultyName;
			}
		}
	}, {
	    header : getCommonTranslation('ALTERNATE_FACULTY_NAME'),
	    dataIndex : 'alternatfacultyName',
	    flex : .1,
	    renderer : function(value,records) {
	    	if(!isNullOrEmpty(records.record.data.alternatFacultyCode) && !isNullOrEmpty(records.record.data.alternatfacultyName)){
				return records.record.data.alternatFacultyCode+"/"+records.record.data.alternatfacultyName;
			}
		}
	}]
});
