Ext.define('Academia.view.program.programDetails.programBatchDetails.pathwaysApproval.PathwaysApprovalForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.pathwaysApprovalForm',
	autoScroll: true,
	frame: true,
	modal: true,
	method: 'POST',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	layout: {
		type: 'vbox'
	},
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
	},
	items : [{
		xtype:'form',
//		plugins:"formlabelrequired",
		items : [{
			xtype: 'fieldset',
			layout: {
				type: 'hbox'
			},
//			title : getPersonModuleTranslation('LMAS_APPROVAL_TYPE'),
			items:[{
				xtype: 'radiogroup',
				itemId: 'approvalType',				
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					margin:'0 5 0 5'
				},
				items:[{ 
					boxLabel: getPersonModuleTranslation('SEQUENTIAL'), 
					name: 'approvalTypeName', 
					inputValue: 'SEQUENTIAL',
					checked:true,
					margin: '0 5 0 0'
				},{ 
					boxLabel: getPersonModuleTranslation('PARALLEL'), 
					name: 'approvalTypeName', 
					inputValue: 'PARALLEL',
				},{ 
					boxLabel: getCommonTranslation('AUTO_APPROVE'), 
					name: 'approvalTypeName', 
					inputValue: 'AUTO_APPROVE',
					//checked:true
				}]
			}]
		},{
			xtype: 'fieldset',
			title : getPersonModuleTranslation('LMAS_SELECT_APPROVAL_LEVEL'),
			//collapsed: false,
			itemId: 'ApprovalLevelsId',
			margin:'10 0 0 0',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 226,
				labelAlign: 'top',
				margin:'0 5 0 5'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('LEVEL1'),
				name: 'userApprovalLevel1',
				itemId: 'userApprovalLevel1',
				store:Ext.create('Academia.store.systemusage.ActiveUserForPathways'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				typeAhead: false,
				editable: true,
				// hideTrigger: true,
				forceSelection: true,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				margin: '0 5 0 0',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				listeners: {
					select: function (combo) {

						var selectedValue = combo.getValue(),
						form = combo.up('form'),
						combos = form.query('customcombobox'),
						duplicateFound = false;

						Ext.Array.each(combos, function (cb) {
							if (cb !== combo && cb.getValue() === selectedValue) {
								duplicateFound = true;
								return false;
							}
						});

						if (duplicateFound) {

							showWarningMessage(
									getCommonTranslation('ALERT'),
									getErrorTranslation('duplicate_search_name')
							);

							combo.suspendEvents();

							combo.setValue(null);
							combo.clearValue();
							combo.lastSelection = null;
							combo.valueModels = null;

							combo.resumeEvents();
						}
					},
					specialkey: function (field, e) {
						if (e.getKey() === e.BACKSPACE || e.getKey() === e.DELETE) {
							Ext.defer(function () {
								if (Ext.isEmpty(field.getRawValue())) {

									field.suspendEvents();
									field.clearValue();
									field.setValue(null);
									field.resumeEvents();
								}
							}, 10);
						}
					},
				}

			},{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('LEVEL2'),
				name: 'userApprovalLevel2',
				itemId: 'userApprovalLevel2',
				store:Ext.create('Academia.store.systemusage.ActiveUserForPathways'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				typeAhead: false,
				// hideTrigger: true,
				forceSelection: true,
				disabled: true,
				//allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				listeners: {
					select: function (combo, records) {
						var selectedValue = combo.getValue(),
						form = combo.up('form'),
						combos = form.query('customcombobox'),
						duplicateFound = false;

						Ext.Array.each(combos, function (cb) {
							if (cb !== combo && cb.getValue() === selectedValue) {
								duplicateFound = true;
								return false; // break loop
							}
						});

						if (duplicateFound) {
							showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('duplicate_search_name'));

							combo.suspendEvents();
							combo.reset();
							combo.resumeEvents();
						}
					},
					specialkey: function (field, e) {
						if (e.getKey() === e.BACKSPACE || e.getKey() === e.DELETE) {
							Ext.defer(function () {
								if (Ext.isEmpty(field.getRawValue())) {

									field.suspendEvents();
									field.clearValue();
									field.setValue(null);
									field.resumeEvents();
								}
							}, 10);
						}
					},
				}

			},{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('LEVEL3'),
				name: 'userApprovalLevel3',
				itemId: 'userApprovalLevel3',
				store:Ext.create('Academia.store.systemusage.ActiveUserForPathways'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				typeAhead: false,
				// hideTrigger: true,
				disabled: true,
				forceSelection: true,
				//allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				listeners: {
					select: function (combo, records) {
						var selectedValue = combo.getValue(),
						form = combo.up('form'),
						combos = form.query('customcombobox'),
						duplicateFound = false;

						Ext.Array.each(combos, function (cb) {
							if (cb !== combo && cb.getValue() === selectedValue) {
								duplicateFound = true;
								return false; // break loop
							}
						});

						if (duplicateFound) {
							showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('duplicate_search_name'));

							combo.suspendEvents();
							combo.reset();
							combo.resumeEvents();
						}
					},
					specialkey: function (field, e) {
						if (e.getKey() === e.BACKSPACE || e.getKey() === e.DELETE) {
							Ext.defer(function () {
								if (Ext.isEmpty(field.getRawValue())) {

									field.suspendEvents();
									field.clearValue();
									field.setValue(null);
									field.resumeEvents();
								}
							}, 10);
						}
					},
				}

			},{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('LEVEL4'),
				name: 'userApprovalLevel4',
				itemId: 'userApprovalLevel4',
				store:Ext.create('Academia.store.systemusage.ActiveUserForPathways'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				disabled: true,
				typeAhead: false,
				// hideTrigger: true,
				forceSelection: true,
				//allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				listeners: {
					select: function (combo, records) {
						var selectedValue = combo.getValue(),
						form = combo.up('form'),
						combos = form.query('customcombobox'),
						duplicateFound = false;

						Ext.Array.each(combos, function (cb) {
							if (cb !== combo && cb.getValue() === selectedValue) {
								duplicateFound = true;
								return false; // break loop
							}
						});

						if (duplicateFound) {
							showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('duplicate_search_name'));

							combo.suspendEvents();
							combo.reset();
							combo.resumeEvents();
						}
					},
					specialkey: function (field, e) {
						if (e.getKey() === e.BACKSPACE || e.getKey() === e.DELETE) {
							Ext.defer(function () {
								if (Ext.isEmpty(field.getRawValue())) {

									field.suspendEvents();
									field.clearValue();
									field.setValue(null);
									field.resumeEvents();
								}
							}, 10);
						}
					},
				}

			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items:[{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'pathwaysApprovalSubmitButtonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'pathwaysApprovalResetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});