Ext.define('Academia.view.program.programDetails.programBatchDetails.pathwaysConfig.PathwaysConfigGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.pathwaysconfiggrid',
    store : 'program.programDetails.programBatches.pathwaysConfig.PathwaysConfigGridStore',
    title : getProgramandcourseTranslation('PATHWAYS_CONFIGURATION'),
    border: true,
    selType:'checkboxmodel',
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'program.programDetails.programBatches.pathwaysConfig.PathwaysConfigGridStore',
    		emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
    		displayInfo : true
    	} ]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
    },
    tbar: [{
    	xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns : [{
    	header : getProgramandcourseTranslation('PRINTNAME'),
	    dataIndex : 'code',
	    flex : .2,
	    sortable : true
    },{
	    header : getProgramandcourseTranslation('PATHWAYS'),
	    dataIndex : 'value',
	    flex : .2,
	    sortable : true
	}]
});