/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.pathwaysConfig.PathwaysConfigWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.pathwaysconfigwin',
	title: getProgramandcourseTranslation('PATHWAYS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	width:500,
	maxHeight:750,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype:'hidden',
            itemId:'recordId',
            name:'recordId'
		},{
			xtype:'textfield',
			itemId:'printNameId',
			name:'printName',
			labelAlign: 'top',
			width: 226,
			fieldLabel: getProgramandcourseTranslation('PRINTNAME'),
		},{
			xtype: 'container',
			itemId: 'dynamicRowsPathwayContainer',
			layout: 'vbox',
			defaults: {
				width: '100%'
			},
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				defaults: {
					labelAlign: 'top'
				},
				items:[{
					xtype:'hidden',
					itemId:'pathwayId',
					name:'pathwayId'
				},{
					xtype: 'customcombobox',
					name: 'pathway',
					itemId:'pathwayItemId',
					store:'program.programDetails.programBatches.pathwaysConfig.PathwaysConfigCsmDataStore',
					fieldLabel: getProgramandcourseTranslation('PATHWAY'),
					valueField: 'id',
					displayField: 'value',
					allowBlank: false,
					editable:false,
					width: 226,
					listeners:{
						select: function(field){
							var container = field.up() && field.up().up(),
							fieldContainer = container.items && container.items.items,
							form = field.up('form'),
							pathwayCount = form.down('#pathwayCountItemId'),
							addBtn = form.down('#addBtn');
							if(field.getDisplayValue() == 'No Secondary Field of Study'){
								pathwayCount.reset();
								pathwayCount.setVisible(false);
								addBtn.setVisible(false);
								for(var i = fieldContainer.length-1; i > 0; i--){
									container.remove(fieldContainer[i]);
								}
							}else{
								 pathwayCount.setVisible(true);
								 addBtn.setVisible(true);
							 }
						}
					}
				},{
					xtype: 'numberfield',
					name: 'pathwayCount',
					itemId:'pathwayCountItemId',
					hideTrigger: true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					allowDecimal:false,
					minValue: 1,
					maxLength: 2,
					width: 45,
					enforceMaxLength : true,
					allowExponential: false,
					style:{
						marginTop:'27px !important'
					}
				},{
					xtype: 'button',
					itemId: 'addBtn',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'27px !important'
					}
				}]
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}],
	listeners: {
		resize: function(win) {
			Ext.defer(function() {
				win.center();
			}, 10);
		}
	}
});