/**
 *  
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.periodTerm.ProgramPeriodTermGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.programperiodtermgrid',
	store:'program.programDetails.programBatches.periodTerm.PeriodTermGridStore',
	resizable:false,
	autoScroll: false,
	cls:'horizontalScrollingFixed',
    selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	border:true,
	title:getProgramandcourseTranslation('LIST_OF_PROGRAM_TERMS'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.programDetails.programBatches.periodTerm.PeriodTermGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
	        var grid=this;                   
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);     
	 },
	    tbar: [{
	    	xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    },{
			xtype : 'button',				
			itemId : 'btnEdit',
			tooltip : getCommonTranslation('EDIT'),
			glyph: ICONGLYPH.EDITGLYPH
		},{
			xtype : 'button',				
			itemId : 'btnView',
			tooltip : getCommonTranslation('VIEW'),//View department
			iconCls: 'view-icon'
		},{
			xtype : 'button',				
			itemId : 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip :getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
		},{ 
			xtype:'textfield',
			name:'periodId',
			itemId:'periodItemId',
			hidden:true
		}],
	columns : [{
		header : getProgramandcourseTranslation('TERM_SEQUENCE'),
		dataIndex : 'sequence',
		flex : 1
	},{
		header : getProgramandcourseTranslation('PROGRAM_TERM'),
		dataIndex : 'programTerm',
		flex : 1
	},{
		header : getProgramandcourseTranslation('TERM_PRINT_NAME'),
		dataIndex : 'printName',
		flex : 1
	},{
		header : getProgramandcourseTranslation('START_DATE'),
		dataIndex : 'startDate',
		flex : 1,
		renderer:function(startDate) {
			return dateRender(startDate);
		}
	},{
		header : getProgramandcourseTranslation('END_DATE'),
		dataIndex : 'endDate',
		flex : 1,
		renderer:function(endDate) {
			return dateRender(endDate);
		}
	}]
});