/**
 * @author Manas Luktuke
 */
var gridStore = Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.RequestTypePeriodMappingStore')
Ext.define('Academia.view.program.programDetails.programBatchDetails.periods.RequestTypePeriodProceedGrid', {  
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.requesttypeperiodproceedgrid',  
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, true);
		this.callParent(arguments);
	},
	store: gridStore,
	title: getCourseTxCommonTranslation('SEARCH_RESULT'),
	border: true,
	refreshStoreData: true,
	headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'requesttypeperiodapplytostructure': 1  
    	}
    },
	selModel: {
		mode: 'SINGLE'
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
//		hidden:true,
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: gridStore,   
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},/* {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},*/ {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getExaminationTranslation('ACADEMY'),
		dataIndex: 'academyName',
		sortable: false,
		flex: 1
	}, {
		header: getExaminationTranslation('LOCATION'),
		dataIndex: 'locationName',
		sortable: false,
		flex: 1
	},{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		sortable: false,
		flex: 1
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		sortable: false,
		flex: 1
	}, {
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		sortable: false,
		flex: 1
	}, {
		header: getProgramandcourseTranslation('MAPPING_STATUS'),
		dataIndex: 'isMapped',
		sortable: false,
		hidden:true,
		flex: 1,
		renderer: function (value, meta, record) {
			if(record.raw.mapped){
				return "Mapped";
			}else{
				return "Mapped";    
			}}
	}]
});