/*
 *  Dharmendra.P
 */

Ext.define('Academia.view.program.programDetails.programBatchDetails.seatTypes.ProgramBatchSeatTypeForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.programbatchseattypewindow',
	modal: true,
	title: getCommonTranslation('SEAT_TYPE_FORM'),
	margin: 0,
	items: [{
		xtype: 'idgeneratorformwin',
		customFieldEntity:CONSTANTS.PROG_BATCH_SEAT_CONFIG,
		columns: 1,
		id:'programbatchseattype_Id',
		margin: 0,
		bodyPadding: '10 10 10 10',
		standardSubmit: false,
		plugins:"formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:240
		},
		items: [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'hidden',
			name : 'processStageId'
		},{
			xtype : 'hidden',
			name : 'batchOfSucceedingProgram'
		},{
			xtype : 'hidden',
			name : 'retainBatch'
		},{
			xtype : 'hidden',
			name : 'version'
		},{
			xtype: 'customcombobox',
			name:'seatType',
			fieldLabel : getCommonTranslation('SEAT_TYPE'),
			store:'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore', 
			valueField : 'id',
			displayField : 'value',
			queryParam:'qry',
			minChars:3,
			queryMode:'local',
			typeAhead : true,
			forceSelection : true,
			allowBlank:false,
			anyMatch : true
		}, {
			xtype : 'numberfield',
			name : 'seatCapacity',
			itemId:'seatCapacity_Id',
			fieldLabel : getCommonTranslation('SEAT_CAPACITY'),
			minValue : 1,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:false,
			allowBlank : false
		} ,{
			xtype: 'customcombobox',
			name:'succeedingSeatType',
			itemId:'succeedingSeatType',
			fieldLabel : getProgramandcourseTranslation('SUCCEEDING_SEAT_TYPE'),
			store:'program.programDetails.programBatches.programSeatType.SucceedingSeatType', 
			valueField : 'id',
			displayField : 'value',
			typeAhead :true,
			allowBlank:false
			//disabled:true
		},{
			xtype: 'customcombobox',
			name:'retainingSeatType',
			itemId:'retainingSeatType',
			fieldLabel : getProgramandcourseTranslation('RETAINING_SEAT_TYPE'),
			store:'program.programDetails.programBatches.programSeatType.RetainingSeatType', 
			valueField : 'id',
			displayField : 'value',
			typeAhead :true,
			allowBlank:false
			//disabled:true
		},{
			xtype: 'textfield',
			name:'processStage',
			readOnly:true,
			hidden:true,
			fieldLabel : getCommonTranslation('SELECTION_PROCESS')
		},{
			xtype:'checkbox',
			itemId : 'whetherEnableEnquiry',
			name:'whetherEnableEnquiry',
			//style:{'margin-left':'10px'},
			boxLabel:getCommonTranslation('WHETHER_ENQUIRY_ENABLE'),
			inputValue: true,
			uncheckedValue: false
		}/*,{
			xtype:'checkbox',
			itemId : 'governmentSubsidyApplicable',
			name:'governmentSubsidyApplicable',
			boxLabel:getCommonTranslation('GOVERNMENT_SUBSIDY_APPLICABLE'),
			inputValue: true,
			uncheckedValue: false,
			hidden: true
		}*/,{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
	      	     	  xtype      : 'radiogroup',
	      	          fieldLabel : getCommonTranslation('GOVERNMENT_SUBSIDY_APPLICABLE'),
	      	        itemId : 'governmentSubsidyApplicable',
	    			name:'governmentSubsidyApplicable',
	      	          defaults: {
	      	              flex: 1
	      	          },
	      	          layout: 'hbox',
	      	          items: [{
	      	                  boxLabel  :getCommonTranslation('YES') ,
	      	                  name      : 'governmentSubsidyApplicable',
	      	                  inputValue: true
	      	              },{
	      	                  boxLabel  : getCommonTranslation('NO'),
	      	                  name      : 'governmentSubsidyApplicable',
	      	                  inputValue: false,
	      	                  checked:true
	      	              }]
	      	      }
			]
		},{
			xtype: 'numberfield',
			itemId: 'subsidyPercentage',
			name: 'subsidyPercentage',
			fieldLabel: getCommonTranslation('SUBSIDY_PERCENTAGE'),
			allowBlank: true,
			minValue: 0.01,
			maxValue: 100,  
			decimalPrecision: 2,
			allowDecimals: true,
			allowExponential: false,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			hidden: true,
			validator: function(value) {
				if (value === null || value === '') {
					return true;
				}
				value = Number(value);
				// Enforce max 2 decimal places (extra safety)
				if (!/^\d+(\.\d{1,2})?$/.test(value)) {
					return 'Only up to 2 decimal places are allowed';
				}
				return true;
			}
		},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel', 
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});