/**
 * @ Deepika Parmar
 */
var ProgramBatchCopyGridStore = Ext.create('Academia.store.program.programDetails.programBatches.ProgramBatchCopyGridStore');
Ext.define('Academia.view.program.programDetails.programBatches.ProgramBatchCopyGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.programbatchcopygrid',
	store : ProgramBatchCopyGridStore,
	border : true,
	autoScroll : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	style : {
		marginLeft : 10
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : ProgramBatchCopyGridStore,
			emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	tbar : [ {
		xtype : 'button',
		itemId : 'btnreset',
		text : getCommonTranslation('RESET'),
		tooltip : getCommonTranslation('RESET')
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'SaveBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true,
			tooltip : getCommonTranslation('SAVE')
		} ]
	} ],
	columns : [{
		header : getCommonTranslation('PERIOD_NAME'),
		dataIndex : 'value',
		flex : 1,
		editor : {
			xtype : 'textfield',
			name : 'periodName',
			itemId : 'periodNameItemId',
			width : 50,
			minValue : 0,
			maxLength : 255,
			allowBlank : false,
			enforceMaxLength : true,
			keyNavEnabled : false,
			mouseWheelEnabled : false,
			allowExponential : false,
			allowDecimals : false
		},
		renderer : function(value, rec, record, rowIndex, colIndex, store, view) {
			if (!isNullOrEmpty(value) && value !== '') {
				try {
					return value;
				} catch (e) {
					return null;
				}
			} else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},
	{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTerm',
		flex : 1,
		editor : {
			xtype : 'customcombobox',
			itemId : 'academicTermItemId',
			name : 'academicTerm',
			store : 'common.AcademicTermStore',
			valueField : 'id',
			displayField : 'value',
			width : 150,
			typeAhead : false,
			forceSelection : true,
			queryParam : 'qry',
			listeners : {
				focus : function(combo, e, eOpts) {
					combo.getStore().load();
				}
			}
		},
		renderer : function(value, rec, record, rowIndex, colIndex, store, view) {
			if (!isNullOrEmpty(value) && value !== '') {
				try {
					var index = rec.column.getEditor().store.findExact('id', value);
					if (index !== -1) {
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					} else {
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				} catch (e) {
					return null;
				}
			} else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},
	{
		header : getCommonTranslation('START_DATE'),
		dataIndex : 'batchStartDate',
		flex : 1,
		editor : {
			xtype : 'datefield',
			name : 'startDate',
			itemId : 'startDateItemId',
			vtype : 'daterange',
			listeners : {
				render : function(field) {
					return dateFormatRender(field);
				},
				change : function(field, newValue, oldValue, eOpts) {
					var grid = field.up('grid');
					var periodEndDateId = grid.columns[3].getEditor();
					periodEndDateId.reset();
					periodEndDateId.setMinValue(field.getValue());
				}
			}
		},
		renderer : function(val, rec, record, rowIndex, colIndex, store, view) {
			var dateVal = dateRender(val);
			if (dateVal == "NaN-NaN-0NaN") {
				return val;
			} else if (!isNullOrEmpty(val)) {
				var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
				if (date == "Invalid date") {
					date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
				}
				return date;
			} else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},
	{
		header : getCommonTranslation('END_DATE'),
		dataIndex : 'batchEndDate',
		flex : 1,
		editor : {
			xtype : 'datefield',
			name : 'endDate',
			itemId : 'endDateItemId',
			vtype : 'daterange',
			listeners : {
				render : function(field) {
					return dateFormatRender(field);
				}
			}
		},
		renderer : function(val, rec, record, rowIndex, colIndex, store, view) {
			var dateVal = dateRender(val);
			if (dateVal == "NaN-NaN-0NaN") {
				return val;
			} else if (!isNullOrEmpty(val)) {
				var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
				if (date == "Invalid date") {
					date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
				}
				return date;
			} else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},
	{
		header : getProgramandcourseTranslation('REGISTRATION_SETUP_NAME'),
		dataIndex : 'registrationSetup',
		flex : 1,
		editor : {
			xtype : 'customcombobox',
			itemId : 'registrationSetupId',
			name : 'registrationSetup',
			store : 'registrationTermSetupDetail.registrationTermSetupDetailStore',
			valueField : 'id',
			displayField : 'value',
			typeAhead : false,
			forceSelection : true,
			queryParam : 'qry',
			listeners : {
				focus : function(combo, e, eOpts) {
					var grid = combo.up('grid');
					var selectionModel = grid.getSelectionModel().getSelection();
					var academicTermId = null;
					if (selectionModel.length > 0) {
						academicTermId = selectionModel[0].data.academicTerm;
					}
					combo.getStore().on('beforeload', function() {
						this.getProxy().setExtraParam('academicTerm', academicTermId);
					});
					combo.getStore().load();

				}
			}
		},
		renderer : function(value, rec, record, rowIndex, colIndex, store, view) {
			if (!isNullOrEmpty(value) && value !== '') {
				try {
					var index = rec.column.getEditor().store.findExact('id', value);
					if (index !== -1) {
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id', value)).data.value;
					} else {
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				} catch (e) {
					return null;
				}
			} else {
				if(!wheatherSchool){
					if(!isNullOrEmpty(record.data.enrollmentLastDate)){
						record.set('registrationSetup','');
						return '';
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				else{
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		}
	},
	{
		header : getCommonTranslation('LAST_DATE_OF_ENROLMENT_PROCESS'),
		dataIndex : 'enrollmentLastDate',
		flex : 1,
		editor : {
			xtype : 'datefield',
			name : 'lastDate',
			itemId : 'lastDateItemId',
			listeners : {
				render : function(field) {
					return dateFormatRender(field);
				}
			}
		},
		renderer : function(val, rec, record, rowIndex, colIndex, store, view) {
			var dateVal = dateRender(val);
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			var startDate = record.data.batchStartDate;
			var endDate = record.data.batchEndDate;

			if (dateVal == "NaN-NaN-0NaN") {
				return val;
			} else if (!isNullOrEmpty(val)) {
				var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
				if (date == "Invalid date") {
					date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
				}
				if(!isNullOrEmpty(startDate) && !isNullOrEmpty(endDate)){
					if(startDate.getTime() <=val.getTime() && endDate.getTime() >=val.getTime()){
						return date;
					}
					else{
						//error
						record.set('enrollmentLastDate','');
						return '';
					}
				}
				return date;
			} else {
				if(!wheatherSchool){
					if(!isNullOrEmpty(record.data.registrationSetup)){
						return '';
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				else{
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		}
	},
	{
		header : getCommonTranslation('DELETE'),
		dataIndex : 'deleteButton',
		flex : 1,
		cls : 'CustomBodyBtnSettings',
		style : {
			'text-align' : 'center'
		},
		sortable : false,
		renderer : function(val, rec, record, rowIndex, colIndex, store, view) {
			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
				return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
			}
			return '';
		}
	}],
	plugins : [{
		ptype : 'cellediting',
		clicksToEdit : 1,
		listeners : {
			beforeedit : function(editor, context) {
				var rowData = context.record.data;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				if(!wheatherSchool){
					if (context.field == 'registrationSetup') {
						if(!isNullOrEmpty(rowData.enrollmentLastDate)){
							return false;
						}
					}
					else if (context.field == 'enrollmentLastDate') {
						if(!isNullOrEmpty(rowData.registrationSetup)){
							return false;
						}
					}
				}
				
				if (context.field == 'enrollmentLastDate') {
					try{
						if(!isNullOrEmpty(context.record.data.batchStartDate)){
							context.column.getEditor().setMinValue(context.record.data.batchStartDate);
						}else{
							context.column.getEditor().setMinValue(false);
						}
						if(!isNullOrEmpty(context.record.data.batchEndDate)){
							context.column.getEditor().setMaxValue(context.record.data.batchEndDate);
						}else{
							context.column.getEditor().setMaxValue(false);
						}
					}
					catch(e){
						//--error
					}
				}
			}
		}
	}]
});