/**
 * @author Seshagiri.k
 */
Ext.define('Academia.view.program.reports.ProgramReportSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.programreportsearchform',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    layout: 'vbox',
    plugins : "formlabelrequired",
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 460,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
//                translationKey:'ACADEMY_LOCATION',
                name: 'academyLocationId',
                itemId: 'academyLocationId',
                store:'common.AcademyLocationNameSeparated',
                displayField: 'value',
                valueField: 'id',
                allowBlank:true,
                minChars:3,
                queryParam:'qry',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            }]
          },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items:[
            {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//                translationKey:'PROGRAM',
                name: 'programId',
                itemId: 'programId',
                disabled:true,
                store:'common.ProgramByAcademyLocationStore',
                displayField: 'valueCode',
                valueField: 'id',
                minChars:3,
                forceSelection:true,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
            },{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('BATCH'),
                name: 'batchId',
                itemId: 'batchId',
                editable: false,
                disabled:true,
                store:'enquiry.AcademicBatchStore',
                displayField: 'value',
                valueField: 'id',
                //allowBlank:false
            }]
        },{
        	xtype:'fieldcontainer',
			width: '100%',
			 
			items:[{  
				   xtype: 'button',
	                text: getCommonTranslation('SEARCH'),
	                itemId: 'btnSearch',
	                ui: 'CustomBtnSubmit',
	                scale: CONSTANTS.BUTTONSIZE,
	                formBind : true

		     },{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'btnReset',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]
    }]
});