/**
 * @author Utsav Chandvaniya
 */
Ext.define('Academia.view.programCourseDashboard.MostAndLeastPopularCourseSearch', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.mostandleastpopularcoursesearch',
	itemId:'mostandleastpopularcoursesearchId',
	cls: 'panelNoSpace',
	autoScroll: false,
	frame: false,
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'panel',
			width: '100%',		
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'mostAndLeastAppliedId',				
				columns: 2,
				vertical: false,				
				items: [
				        { boxLabel: getProgramandcourseTranslation('MOST_APPLIED'), name: 'mostAndLeastApplied', inputValue: 'MOST_APPLIED',checked:true},
				        { boxLabel: getProgramandcourseTranslation('LEAST_APPLIED'), name: 'mostAndLeastApplied', inputValue: 'LEAST_APPLIED'}
				        ]
			}]	
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults :{
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'PROGRAM',
				name : 'programId',
				itemId : 'programId',      	   
				store : 'common.ProgramsByAcademyLocationsIds',
				displayField : 'valueCode',
				valueField : 'id',
				typeAhead : false,
				forceSelection : true,
				//allowBlank : false,
				hidden : false,
				//queryMode:'local' ,
				queryParam: 'programName',
			    minChars: 3,
			    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    listConfig: {
	                listeners: {
	                    beforeshow: function(
	                        picker) {
	                        picker.minWidth = picker
	                            .up('combobox')
	                            .getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code} / {value}' +
	                        '</div>';
	                }
	            }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),		

				name : 'batchId',
				itemId : 'batchId',
				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				disabled:true,
				forceSelection : true,
				allowBlank : false
			}]},{
				xtype:'fieldcontainer',
				layout:'hbox',
				defaults :{
					labelAlign:'top',
					width:226
				},
				items: [{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('PERIOD'),

					name : 'periodId',
					itemId : 'periodId',
					store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					disabled:true,
					forceSelection : true,
					allowBlank : false
				},{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
					name : 'courseIdPBS',
					itemId : 'courseIdPBS',
					store : 'coursetransaction.coursereading.CourseByPeriod',
					displayField : 'valueCode',
					valueField : 'id',
					minChars:3,
					disabled:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					typeAhead : true,
					forceSelection : true,
					allowBlank : false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					queryParam:'name',
					listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{courseCodeName}'  +
			                    '</div>';
			                }
			            }
				}]
			},{
				xtype: 'fieldcontainer',
				width: '100%',

				items: [ {
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'btnSearch',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE               
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'btnReset',
					// buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}]	
			}]
	},{
		xtype:'panel',
		items:[{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('MOST_AND_LEAST_POPULAR_COURSES'),
			width: '100%',
			itemId:'mostleastpopularcoursespbsGridId',
			hidden : false,
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		},{
			xtype : 'searchresultgrid',
			title :getProgramandcourseTranslation('MOST_AND_LEAST_POPULAR_COURSES'),
			width : '100%',
			itemId : 'mostleastpopularcoursescbsGridId',
			hidden : true,
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		}]
	}]
});