/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.programCourseDashboard.StudentNewSessionReportFilter', {   
	extend : 'Ext.panel.Panel',
	alias : 'widget.studentnewsessionreportfilter',
	autoScroll: false,
	frame: false,
	cls:'panelNoSpace',
	items: [{
			xtype:'form',
			plugins:"formlabelrequired",
			cls:'customSearchPanel',
			items:[{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults :{
						labelAlign:'top',
						width:226
					},
					items: [{
							xtype : 'customcombobox',
							fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
							name : 'student_programId_New',
							itemId : 'student_programId_New',
							store:Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
							displayField:'valueCode',
							valueField:'id',
							width:226,
							typeAhead:true,
							forceSelection:true,
							queryParam:'programName',
							minChars:3,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code}'  +
									'</div>';
								}
							}
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('BATCH'),		
							name : 'student_batchId_New',
							itemId : 'student_batchId_New',
							store : Ext.create('Academia.store.program.programDetails.programBatches.ProgramBatchesGridStore'),
							displayField : 'name',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							hidden : false
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('PERIOD'),
							name : 'periodId_student_New',
							itemId : 'periodId_student_New',
							store : Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
							displayField : 'value',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							disabled:true
						}]
				},{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults :{
						labelAlign:'top',
						width:226
					},
					items: [{
							xtype: 'customcombobox',
							name: 'courseCBSId1_New',
							itemId: 'courseCBSId1_New',
							fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
							valueField: 'id',
							displayField: 'valueCode',
							queryParam:'name',
							minChars:3,
							store : Ext.create('Academia.store.common.StudentEnrollCourseAndSectionStore'),
							typeAhead:true,
							triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
							enableKeyEvents  : 'true',
							hideTrigger:false,
							forceSelection:true,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							width:226,
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code}'  +
									'</div>';
								}
							}
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('SECTION'),
							name : 'student_programSectionId_New',
							itemId : 'student_programSectionId_New',
							store : Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
							displayField : 'value',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							disabled:true
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('SECTION'),
							name : 'student_courseSectionId_New',
							itemId : 'student_courseSectionId_New',
							store : Ext.create('Academia.store.common.StudentEnrollCourseAndSectionStore'),
							displayField : 'value',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							disabled:true,
							hidden:true
						},{
							xtype: 'customcombobox',
							fieldLabel: getCourseTxCommonTranslation('FACULTY'),
							name: 'facultyId_student_New',
							itemId:'facultyId_student_New',
							store:'common.MappedFacultyStore',
							valueField: 'id',
							displayField: 'valueCode',
							queryParam:'name',
							minChars:3,
							typeAhead:false,
							hideTrigger:false,
							triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
							triggerAction: '',
							forceSelection:true,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code} / {value}' +
									'</div>';
								}
							}
						}]
				},{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults :{
						labelAlign:'top',
						width:226
					},
					items: [{
							xtype: 'datefield',
							name:'fromDate_New',
							itemId:'fromDate_New',
							fieldLabel:getServiceRequestTranslation('FROM_DATE'),
							//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							},
							vtype: 'daterange',
							endDateField: 'toDate_New',
							editable:false
						},{
							xtype: 'datefield',
							name:'toDate_New',
							itemId:'toDate_New',
							fieldLabel:getServiceRequestTranslation('TO_DATE'),
							vtype: 'daterange',
							startDateField: 'fromDate_New',
							editable:false,
							//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}
						}]
				},{
					xtype: 'fieldcontainer',
					width: '100%',
					items: [{
							xtype: 'button',
							text: getCommonTranslation('SEARCH'),
							itemId: 'btnSearch_New',
							buttonAlign: 'left',
							ui: 'CustomBtnSubmit',
							scale: CONSTANTS.BUTTONSIZE               
						},{
							xtype: 'button',
							text: getCommonTranslation('RESET'),
							itemId: 'btnReset_New',
							ui: 'CustomBtnCancel',
							scale: CONSTANTS.BUTTONSIZE   
						}]	
				}]
		}]
});