/**
 *  @author Amit G
 */

Ext.define('Academia.view.quartz.QuartzListWithStatus', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.quartzlistwithstatus',
	store : 'quartz.QuartzJobWithStatusListStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'quartz.QuartzJobWithStatusListStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getCommonTranslation('JOB_NAME'),
		dataIndex : 'jobName',
		flex:1
	},/*{
		header : getCommonTranslation('NEXT_FIRE_TIME'),
		dataIndex : 'nextFireTime',
		flex:1,
		renderer: function(dateTime) {
			return dateRender(dateTime)+" "+timeRender(dateTime);
		}
	},*/{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	},{
		header : getCommonTranslation('USER'),
		dataIndex : 'userName',
		hidden : true,
		flex:1
	},{
		header : getCommonTranslation('PERCENTAGE_COMPLETED'),
		dataIndex : 'percentageCompleted',
		flex:1
	}]
});