/**
 * @author Varsha Gour
 */
Ext.define('Academia.view.receipt.receiptsettings.EditReceiptSettingsWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.editreceiptsettingswin',
    title: getCommonTranslation('RS_RECEIPT_SETTINGS'),
    modal: true,
    autoScroll: true,
    items: [{
        xtype: 'form',
        itemId: 'editReceiptSettingsFormItemId',
        method: 'POST',
        defaults: {
            labelAlign: 'top',
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                name: 'id',
                itemId: 'idItemId'
            }, {
                xtype: 'customcombobox',
                name: 'academyLocationId',
                itemId: 'academyLocationItemId',
                autoloadStore: false,
                width: 460,
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                store: 'common.AcademyLocationNameSeparated',
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                readOnly: true
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'numberfield',
                name: 'numberOfDays',
                itemId: 'numberOfDaysItemId',
                fieldLabel: getCommonTranslation('RS_BACK_DATE_DAYS'),
                allowBlank: false,
                minValue: 1,
                maxValue: 1000,
                maxLength: 4,
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'right',
				width:230,
			},
            items: [{
    			xtype: 'checkboxfield',
    			labelAlign: 'right',
    			boxLabel: getFeeAndPaymentCommonTranslation('ALLOW_AMOUNT_VALUE_IN_DECIMAL'),
    			name: 'allowAmountValueInDecimal',
    			itemId: 'allowAmountValueInDecimal',
    			inputValue: true
    		}
            ,{
    			xtype: 'checkboxfield',
    			labelAlign: 'right',
    			boxLabel: getFeeAndPaymentCommonTranslation('AUTO_FETCH_RECEIPT_AMOUNT'),
    			name: 'autoFetchReceiptAmount',
    			itemId: 'autoFetchReceiptAmount',
    			inputValue: true
    		}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginLeft: '-3px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveEditReceiptSettingsWinItemId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancelEditReceiptSettingsWinItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});