/**
 *  @author manisha wagh
 */

Ext.define('Academia.view.receipt.receiptsettings.PaymentGrpALProgramBatchSeatTypeGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymentgrpaLprogrambatchseattypegrid',
	title : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
	store: 'feeandpayment.finance.FinanceALProgramBatchSeatTypeList',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype: 'button',
		text: getFeeAndPaymentCommonTranslation('SUBMIT'),
		tooltip: getFeeAndPaymentCommonTranslation('SUBMIT'),
		itemId: 'submitPaymentGrpMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getFeeAndPaymentCommonTranslation('RESET'),
		tooltip: getFeeAndPaymentCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1	 
	}]
});