/**
 * @author Pravin.Surve
 * this is Quick search Form Of Quota report
 */
Ext.define('Academia.view.reports.admission.QuotaReportSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.quotareportsearchform',
    //frame: true,
    cls:'customSearchPanel',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'stageObject',
        name: 'stageObject'
    },{
        xtype: 'fieldcontainer',
        itemId: 'quotaReportprogrmBatchSeatTypeContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
	       	 xtype: 'customcombobox',
	    	 fieldLabel: getCommonTranslation('PROGRAM'),
//	    	 translationKey : 'PROGRAM',
	         allowBlank: false,
	         name: 'programId',
	         itemId: 'programId',
	         valueField: 'id',                
	         displayField: 'value',
	         queryMode: 'local',
	         autoLoad: false,
	         typeAhead: true,
             forceSelection: true,
             triggerAction: 'all',
             minChars:3,
             store:Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds'),
             queryParam:'programName',
             enableKeyEvents:true,
             emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	         listeners: {
	            /*    render: function(combo) {
	                    var store = Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds');
	                    combo.bindStore(store);
	                },*/
	        	 	focus: function(combo){
	        	 		combo.expand();
	        	 		combo.onTriggerWrapClick();
	        		},
	        		delay: 1,
	                keypress:function(combo,eOpt){
	                	if(combo.getValue().length > 2){
	                		combo.queryMode = "remote";
	                	}
	                }
	            }
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getCommonTranslation('BATCH'),
	        editable: false,
	        allowBlank: false,
	        name: 'batchId',
	        itemId: 'batchId',
	        valueField: 'id',                
	        displayField: 'value',
	        queryMode: 'local',
	        listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getCommonTranslation('SEAT_TYPE'),
	        editable: false,
	        allowBlank: false,
	        name: 'seatTypeId',
	        itemId: 'seatTypeId',
	        valueField: 'seatTypeId',                
	        displayField: 'seatTypeName',
	        queryMode: 'local',
	        listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            }
    }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'selectionComboContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
    		xtype: 'customcombobox',
    		width: 226,
    		itemId: 'selectionStageCombo',
            store: 'Academia.store.admission.selectionStage.SelectionStageFromSeatType',
    		fieldLabel: getAdmissionTranslation('SELECT_STAGE'),
    		labelAlign: 'top',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            allowBlank: false
    	}]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getAdmissionTranslation('SEARCH'),
            itemId: 'quotaReportFindButtonId',
            formBind: true,
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getAdmissionTranslation('CLEAR_SEARCH'),
            itemId: 'quotaReportClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});