/**
 * This view is used for admission statistics view 
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.admission.dashboard.AdmissionStatisticsView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.admissionstatisticsview',
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
    	xtype: 'form',
    	//frame: true,
    	cls:'customSearchPanel',
    	plugins: "formlabelrequired",
        itemId: 'admissionStatisticsSearchForm',
        items:[{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'admissionStaticsAcademyYearContainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                name: 'admissionStatistics',
//                width: 300,
                labelWidth : 170,
                labelAlign: 'top',
                fieldLabel: getAdmissionTranslation('SHOW_STATISTICS_FOR'),
                itemId: 'admissionStatistics',
                displayField: 'name',
                valueField: 'value',
                allowBlank: false,
                queryMode: 'local',
                editable: false,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.reports.admission.AdmissionStatisticReportStore');
                        combo.bindStore(store);
                    }
                }
            },{
            	xtype : 'customcombobox',
            	fieldLabel : getCommonTranslation('INTAKE_YEAR'),
            	name : 'intakeYear',
            	itemId : 'intakeYear',
            	displayField:'value',
            	valueField:'id',
            	width:226,
            	typeAhead:true,
            	forceSelection:true,
            	minChars:3,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code}'  +
            			'</div>';
            		}
            	},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.IntakeYearStore');
            			combo.bindStore(store)
            		}
            	}
            },{
            	xtype : 'customcombobox',
            	fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
            	name : 'academicTerm',
            	itemId : 'academicTerm',
            	displayField : 'value',
            	valueField : 'id',
            	typeAhead : true,
            	forceSelection : true,
            	hidden : false,
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.AcademicTermStore');
            			combo.bindStore(store)
            		}
            	}
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
    		itemId: 'admissionStaticsDateContainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'datefield',
                fieldLabel: getAdmissionTranslation('START_DATE'),
                name: 'startDate',
                itemId :'startDate',
                vtype: 'daterange',
    			endDateField: 'endDate',
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
            },{
                xtype: 'datefield',
                fieldLabel: getAdmissionTranslation('END_DATE'),
                name: 'endDate',
                itemId: 'endDate',
                vtype: 'daterange',
    			startDateField: 'startDate',
                listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT
            },{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel: getCommonTranslation('SEAT_TYPE'),
				name: 'seatType',
				itemId:'seatType',
				displayField: 'value',
				valueField: 'id',
				typeAhead : true,
				forceSelection : true,
				editable: false,
	            disableKeyFilter: false,
	            store:Ext.create('Academia.store.common.AllSeatTypeListStore'),
	            listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code}'  + '{value}' +
            			'</div>';
            		}
            	}
			}]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getAdmissionTranslation('SEARCH'),
                itemId: 'admissionStatisticsFindButtonId',
                buttonAlign: 'right',
                formBind: true,
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getAdmissionTranslation('CLEAR_SEARCH'),
                itemId: 'admissionStatisticsClearSearch',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]	
    }, {
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	width: '100%',
        minHeight: 300,
    	items: [{
    		xtype: 'panel',
    		layout:'vbox',
    		items: [{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			items:[{
    				xtype: 'label',
    				width : 300,
    				text: getAdmissionTranslation('STATISTICS_BY_ACADEMIES'),
    				style: {
    					color : 'black',
    					'text-align': 'center',
    					'font-weight': 'bold',
    					'font-size': '16px'
    				},
    			},{
    				xtype: 'button',
    				itemId: 'academyExtraBtns',
    				hidden:true,
    				cls:'CustomToolbarBtnExport',
    				iconCls:'export-image-icon',
    			//	style:{marginLeft:'-40px'},
    				menu: []
    			}]
    		}, {
                xtype: 'piechartreport',
                itemId: 'admissionStatisticsByAcademiesPieChart',
                width : 310,
                minHeight : 320,
                store: 'Academia.store.reports.admission.AdmissionStatisticsByAcademies',
                numericField: 'count',
                categoryField: 'name'
            },{
            	xtype: 'displayfield',
            	itemId : 'incomeRangeChartField',
            	width : 300,
            	fieldStyle: {
            		marginTop : '70px',
            		marginLeft : '108px !important'
            	},
            	name: 'incomeRangeChartField',
            	value : 'No data to display',
            	hidden: true
            }]
    	}, {
    		xtype: 'panel',
    		layout:'vbox',
    		items: [{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			items:[{
    				xtype: 'label',
    				width : 300,
    				text: getAdmissionTranslation('STATISTICS_BY_LOCATIONS'),
    				style: {
    					color : 'black',
    					'text-align': 'center',
    					'font-weight': 'bold',
    					'font-size': '16px'
    				}
    			},{
    				xtype: 'button',
    				itemId: 'locationExtraBtns',
    				hidden:true,
    				cls:'CustomToolbarBtnExport',
    				iconCls:'export-image-icon',
    				//style:{marginLeft:'-20px'},
    				menu: []
    			}]
    		}, {
                xtype: 'piechartreport',
                width : 310,
                minHeight : 320,
                itemId: 'admissionStatisticsByLocationsPieChart',
                store: 'Academia.store.reports.admission.AdmissionStatisticsByLocations',
                numericField: 'count',
                categoryField: 'name'
            },{
            	xtype: 'displayfield',
            	itemId : 'incomeRangeChartField',
            	width : 300,
            	fieldStyle: {
            		marginTop : '70px',
            		marginLeft : '108px !important'
            	},
            	name: 'incomeRangeChartField',
            	value : 'No data to display',
            	hidden: true
            }]
    	}]
    }, {
		xtype: 'panel',
		layout:'vbox',
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			items:[{
				xtype: 'label',
				width : 700,
				text: getAdmissionTranslation('STATISTICS_BY_PROGRAMS'),
				style: {
					color : 'black',
					'text-align': 'center',
					'font-weight': 'bold',
					'font-size': '16px'
				}
			},{
				xtype: 'button',
				itemId: 'programExtraBtns',
				hidden:true,
				cls:'CustomToolbarBtnExport',
				iconCls:'export-image-icon',
				style:{marginLeft:'-115px'},
				menu: []
			}]
		},{
            xtype: 'barchartreport',
            itemId: 'admissionStatisticsByProgramBarChart',
            minWidth: 1400,
            height: 500,
            columnHeight: 30,
            columnColor: 'orange',
            store: 'Academia.store.reports.admission.AdmissionStatisticsByProgram',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getAdmissionTranslation('COUNT_OF_ADMISSION'),
            yAxesCategoryField: 'name',
            yAxesCategoryTitle: getAdmissionTranslation('PROGRAM')
        },{
        	xtype: 'displayfield',
        	itemId : 'incomeRangeChartField',
        	width : 300,
        	fieldStyle: {
        		marginTop : '70px',
        		marginLeft : '290px !important'
        	},
        	name: 'incomeRangeChartField',
        	value : 'No data to display',
        	hidden: true
        }]
	}]
});